/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BaseNetworkConnector;
import pt.com.broker.client.HostInfo;

public class SslNetworkConnector
extends BaseNetworkConnector {
    private static final Logger log = LoggerFactory.getLogger(SslNetworkConnector.class);
    private SSLContext sslContext;
    private SSLSession ssl_session;

    public SslNetworkConnector(HostInfo hostInfo, SSLContext sslContext) throws UnknownHostException, IOException {
        super(hostInfo);
        this.sslContext = sslContext;
    }

    private SocketFactory getSslSocketFactory() {
        SSLSocketFactory sf = null;
        try {
            sf = this.sslContext.getSocketFactory();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return sf;
    }

    @Override
    public synchronized void connect(HostInfo host, long connectionVersion) throws Throwable {
        log.warn("Trying to reconnect (SSL)");
        this.hostInfo = host;
        this.setConnectionVersion(connectionVersion);
        SocketFactory socketFactory = this.getSslSocketFactory();
        this.client = socketFactory.createSocket();
        this.client.setReceiveBufferSize(262144);
        this.client.setSendBufferSize(262144);
        this.client.connect(new InetSocketAddress(host.getHostname(), host.getPort()), 15000);
        this.getSocket().setSoTimeout(0);
        this.ssl_session = ((SSLSocket)this.client).getSession();
        this.rawOutput = new DataOutputStream(this.getSocket().getOutputStream());
        this.rawInput = new DataInputStream(this.getSocket().getInputStream());
        this.socketAddress = this.getSocket().getRemoteSocketAddress();
        this.socketAddressLiteral = this.socketAddress.toString();
        log.info("Connection established (SSL): " + this.socketAddressLiteral);
        this.closed = false;
    }

    protected SSLSession getSSLSession() {
        return this.ssl_session;
    }
}

