/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.concurrent.CustomExecutors;
import pt.com.broker.client.BaseNetworkConnector;

public abstract class ProtocolHandler<T> {
    private final ExecutorService exec = CustomExecutors.newThreadPool((int)4, (String)"protocol-handler");
    private final ScheduledExecutorService shed_exec = CustomExecutors.newScheduledThreadPool((int)1, (String)"sched-protocol-handler");
    protected AtomicBoolean closed = new AtomicBoolean(false);
    protected volatile boolean readerStarded = false;
    private final Runnable reader = new Runnable(){

        @Override
        public void run() {
            BaseNetworkConnector connector = ProtocolHandler.this.getConnector();
            DataInputStream in = connector.getInput();
            boolean continueReading = true;
            long connectionVersion = connector.getConnectionVersion();
            while (continueReading) {
                try {
                    Object message = ProtocolHandler.this.doDecode(in);
                    ProtocolHandler.this.handleReceivedMessage(message);
                }
                catch (Throwable error) {
                    Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)error);
                    if (ProtocolHandler.this.getNumberOfTries() == 0) {
                        if (!ProtocolHandler.this.closed.get()) {
                            ProtocolHandler.this.onError(rootCause);
                        }
                        return;
                    }
                    if (rootCause instanceof IOException) {
                        if (!connector.isClosed()) {
                            ProtocolHandler.this.onIOFailure(connectionVersion);
                        }
                        continueReading = false;
                        continue;
                    }
                    try {
                        if (ProtocolHandler.this.closed.get()) continue;
                        ProtocolHandler.this.onError(rootCause);
                    }
                    catch (Throwable t) {}
                }
            }
        }
    };

    public abstract T decode(DataInputStream var1) throws IOException;

    public abstract void encode(T var1, DataOutputStream var2) throws IOException;

    public abstract void onConnectionClose();

    public abstract void onConnectionOpen();

    public abstract void onError(Throwable var1);

    protected abstract void onIOFailure(long var1);

    public abstract BaseNetworkConnector getConnector();

    protected abstract void handleReceivedMessage(T var1);

    protected abstract int getNumberOfTries();

    private Throwable resetConnection(BaseNetworkConnector connector, Throwable error, long connectionVersion) {
        Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)error);
        if (rootCause instanceof IOException) {
            if (this.getNumberOfTries() == 0) {
                return rootCause;
            }
            this.onIOFailure(connectionVersion);
        }
        return rootCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T doDecode(DataInputStream in) throws IOException {
        DataInputStream dataInputStream = in;
        synchronized (dataInputStream) {
            return this.decode(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEncode(T message, DataOutputStream out) throws IOException {
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            this.encode(message, out);
        }
    }

    public void sendMessage(T message) throws Throwable {
        BaseNetworkConnector connector = this.getConnector();
        long connectionVersion = connector.getConnectionVersion();
        try {
            DataOutputStream out = connector.getOutput();
            this.doEncode(message, out);
        }
        catch (Throwable error) {
            Throwable rootCause = this.resetConnection(connector, error, connectionVersion);
            this.onError(rootCause);
            throw rootCause;
        }
    }

    public final void start() throws Throwable {
        this.readerStarded = true;
        this.exec.execute(this.reader);
    }

    public final void stop() {
        this.closed.set(true);
        this.getConnector().close();
        try {
            this.exec.shutdown();
            this.shed_exec.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

