/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.concurrent.Sleep;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;

public class Consumer
implements BrokerListener {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Pattern nl_clean = Pattern.compile("[\\n\\r]");
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;
    private long waitTime;
    private NetProtocolType protocolType;
    private boolean isRaw;
    private boolean strip;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        Consumer consumer = new Consumer();
        consumer.host = cargs.getHost();
        consumer.port = cargs.getPort();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        consumer.waitTime = cargs.getDelay();
        consumer.protocolType = NetProtocolType.valueOf((String)cargs.getProtocolType());
        consumer.isRaw = cargs.getOutput().equals("raw");
        consumer.strip = cargs.stripNewlines();
        if (consumer.isRaw) {
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            root.setLevel(Level.OFF);
        }
        BrokerClient bk = new BrokerClient(consumer.host, consumer.port, "tcp://mycompany.com/mysniffer", consumer.protocolType);
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        bk.addAsyncConsumer(subscribe, consumer);
        if (!consumer.isRaw) {
            System.out.println("listening...");
        }
    }

    @Override
    public boolean isAutoAck() {
        return this.dtype != NetAction.DestinationType.TOPIC;
    }

    @Override
    public void onMessage(NetNotification notification) {
        String payload = this.strip ? nl_clean.matcher(new String(notification.getMessage().getPayload())).replaceAll("") : new String(notification.getMessage().getPayload());
        if (this.isRaw) {
            System.out.println(payload);
        } else {
            System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), counter.incrementAndGet());
            System.out.printf("Destination: '%s'%n", notification.getDestination());
            System.out.printf("Subscription: '%s'%n", notification.getSubscription());
            System.out.printf("Timestamp: '%s'%n", new Date(notification.getMessage().getTimestamp()));
            Map headers = notification.getHeaders();
            if (headers != null && headers.size() != 0) {
                System.out.printf("Headers:", new Object[0]);
                for (String key : headers.keySet()) {
                    System.out.printf("  %s ->  %s%n", key, headers.get(key));
                }
            }
            System.out.printf("Payload: '%s'%n", payload);
        }
        if (this.waitTime > 0L) {
            Sleep.time((long)this.waitTime);
        }
    }
}

