/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.caudexorigo.text.RandomStringUtils;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetPublish;

public class FastProducer {
    private String _host;
    private int _port;
    private Socket _client;
    private DataOutputStream _rawo = null;
    private DataInputStream _rawi = null;

    public FastProducer(String host, int port) {
        this._host = host;
        this._port = port;
        try {
            this._client = new Socket(this._host, this._port);
            System.out.printf("Socket -> sendBufferSize: %s%n", this._client.getSendBufferSize());
            this._client.setSendBufferSize(this._client.getSendBufferSize() * 4);
            System.out.printf("Socket -> sendBufferSize: %s%n", this._client.getSendBufferSize());
            this._rawo = new DataOutputStream(this._client.getOutputStream());
            this._rawi = new DataInputStream(this._client.getInputStream());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public int messageLenght() throws IOException {
        return this._rawi.readInt();
    }

    public void readfully(byte[] buf) throws IOException {
        this._rawi.readFully(buf);
    }

    private void closeQuietly() {
        try {
            this._rawi.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._rawo.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._client.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendBatch(String destinationName, String destinationType, int batchSize) {
        try {
            byte[] message = this.getMesssage(destinationName, destinationType);
            for (int i = 0; i < batchSize; ++i) {
                this._rawo.writeShort(1);
                this._rawo.writeShort(0);
                this._rawo.writeInt(message.length);
                this._rawo.write(message);
                if (i % 5000 != 0) continue;
                System.out.printf("Sent messages: %s%n", i);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
        this.closeQuietly();
    }

    private byte[] getMesssage(String destinationName, String destinationType) {
        byte[] encodedMsg;
        int msize = 25600;
        NetBrokerMessage msg = new NetBrokerMessage(RandomStringUtils.randomAlphabetic((int)msize));
        ProtoBufBindingSerializer serializer = new ProtoBufBindingSerializer();
        if (destinationType.equals("TOPIC")) {
            NetPublish publish = new NetPublish(destinationName, NetAction.DestinationType.TOPIC, msg);
            NetAction action = new NetAction(NetAction.ActionType.PUBLISH);
            action.setPublishMessage(publish);
            NetMessage message = new NetMessage(action);
            encodedMsg = serializer.marshal(message);
        } else if (destinationType.equals("QUEUE")) {
            NetPublish publish = new NetPublish(destinationName, NetAction.DestinationType.QUEUE, msg);
            NetAction action = new NetAction(NetAction.ActionType.PUBLISH);
            action.setPublishMessage(publish);
            NetMessage message = new NetMessage(action);
            encodedMsg = serializer.marshal(message);
        } else {
            throw new IllegalArgumentException("Not a valid destination type!");
        }
        return encodedMsg;
    }

    public static void main(String[] args) throws Throwable {
        String host = "127.0.0.1";
        int port = 3323;
        FastProducer fpb = new FastProducer("127.0.0.1", 3323);
        System.out.println("************* Start sendLoop() ******************");
        long start = System.currentTimeMillis();
        fpb.sendBatch("/queue/old", "QUEUE", 10000);
        long stop = System.currentTimeMillis();
        double duration = (double)(stop - start) / 1000.0;
        System.out.printf("Time for sending: %6.2f seconds.%n", duration);
        System.exit(0);
    }
}

