/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.concurrent.Sleep;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;

public class NoAckQueueConsumer
implements BrokerListener {
    private final AtomicInteger counter = new AtomicInteger(0);
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;
    private long waitTime;
    private NetProtocolType protocol;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        NoAckQueueConsumer consumer = new NoAckQueueConsumer();
        consumer.host = cargs.getHost();
        consumer.port = cargs.getPort();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        consumer.waitTime = cargs.getDelay();
        consumer.protocol = NetProtocolType.valueOf((String)cargs.getProtocolType());
        BrokerClient bk = new BrokerClient(consumer.host, consumer.port, "tcp://mycompany.com/mysniffer", consumer.protocol);
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        subscribe.addHeader("ACK_REQUIRED", "false");
        bk.addAsyncConsumer(subscribe, consumer);
        System.out.println("listening...");
    }

    @Override
    public boolean isAutoAck() {
        return false;
    }

    @Override
    public void onMessage(NetNotification notification) {
        System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), this.counter.incrementAndGet());
        System.out.printf("Destination: '%s'%n", notification.getDestination());
        System.out.printf("Subscription: '%s'%n", notification.getSubscription());
        System.out.printf("Payload: '%s'%n", new String(notification.getMessage().getPayload()));
        Map headers = notification.getHeaders();
        if (headers != null) {
            System.out.printf("Headers: %n", new Object[0]);
            for (String headerName : headers.keySet()) {
                System.out.printf(" '%s' - '%s'%n", headerName, headers.get(headerName));
            }
        }
        Sleep.time((long)this.waitTime);
    }
}

