/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.Sleep;
import org.caudexorigo.io.NullOutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class PayConsumer
implements BrokerListener {
    private static final Logger log = LoggerFactory.getLogger(PayConsumer.class);
    private static final NullOutputWriter dev_null = new NullOutputWriter();
    private final NetAction.DestinationType dtype = NetAction.DestinationType.QUEUE;
    private final long waitTime;
    private BrokerClient bk;
    private int msgCount;

    public PayConsumer(String host, int port, String dname, long waitTime, int msgCount) {
        this.waitTime = waitTime;
        this.msgCount = msgCount;
        try {
            this.bk = new BrokerClient(host, port);
            NetSubscribe subscribe = new NetSubscribe(dname, this.dtype);
            this.bk.addAsyncConsumer(subscribe, this);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    @Override
    public boolean isAutoAck() {
        return false;
    }

    @Override
    public void onMessage(NetNotification notification) {
        try {
            log.info("Received message: {}", (Object)new String(notification.getMessage().getPayload()));
            if (this.waitTime > 0L) {
                Sleep.time((long)this.waitTime);
            }
            --this.msgCount;
            this.bk.acknowledge(notification);
            if (this.msgCount == 0) {
                this.bk.unsubscribe(this.dtype, notification.getDestination());
                this.deleteQueue(notification.getDestination());
                this.bk.close();
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage());
        }
    }

    private void deleteQueue(String queueName) {
        try {
            String endpoint = "http://localhost:3380/broker/admin";
            String delete = String.format("QUEUE:%s", queueName);
            System.out.println("PayConsumer.deleteQueue: " + delete);
            URL url = new URL(endpoint);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-length", String.valueOf(delete.length()));
            con.setRequestProperty("Content-Type", "");
            con.setDoOutput(true);
            con.setDoInput(true);
            DataOutputStream output = new DataOutputStream(con.getOutputStream());
            output.writeBytes(delete);
            output.flush();
            output.close();
            DataInputStream input = new DataInputStream(con.getInputStream());
            int c = input.read();
            while (c != -1) {
                System.out.print((char)c);
                c = input.read();
            }
            input.close();
        }
        catch (Throwable t) {
            log.error(t.getMessage());
        }
    }
}

