/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.Sleep;
import org.caudexorigo.text.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.types.NetBrokerMessage;

public class PayProducer {
    private static final Logger log = LoggerFactory.getLogger(PayProducer.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    private final String dname;
    private final long waitTime;
    private BrokerClient bk;
    private int msgCount;

    public PayProducer(String host, int port, String dname, long waitTime, int msgCount) {
        this.dname = dname;
        this.waitTime = waitTime;
        this.msgCount = msgCount;
        try {
            this.bk = new BrokerClient(host, port);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public void sendLoop(int messageLength) {
        log.info("Start sending string of {} random alphanumeric characters in 1 seconds to '{}' ...", (Object)messageLength, (Object)this.dname);
        for (int i = 0; i < this.msgCount; ++i) {
            String msg = i + " - " + RandomStringUtils.randomAlphanumeric((int)messageLength);
            NetBrokerMessage brokerMessage = new NetBrokerMessage(msg);
            this.bk.enqueueMessage(brokerMessage, this.dname);
            log.info(String.format("%s -> Send Message: %s", this.counter.incrementAndGet(), msg));
            Sleep.time((long)this.waitTime);
        }
        this.bk.close();
    }
}

