/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.cli.CliFactory;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.SslBrokerClient;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class SslConsumer
implements BrokerListener {
    private final AtomicInteger counter = new AtomicInteger(0);
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        SslConsumer consumer = new SslConsumer();
        consumer.host = cargs.getHost();
        consumer.port = cargs.getPort();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        SslBrokerClient bk = new SslBrokerClient(consumer.host, consumer.port);
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        bk.addAsyncConsumer(subscribe, consumer);
        System.out.println("listening...");
    }

    @Override
    public boolean isAutoAck() {
        return this.dtype != NetAction.DestinationType.TOPIC;
    }

    @Override
    public void onMessage(NetNotification notification) {
        System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), this.counter.incrementAndGet());
        System.out.printf("Destination: '%s'%n", notification.getDestination());
        System.out.printf("Subscription: '%s'%n", notification.getSubscription());
        System.out.printf("Payload: '%s'%n", new String(notification.getMessage().getPayload()));
    }
}

