/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.concurrent.Sleep;
import org.caudexorigo.text.RandomStringUtils;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.UdpClient;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetPublish;

public class UDPProducer {
    private String host;
    private int udpPort;
    private NetAction.DestinationType dtype;
    private String dname;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        UDPProducer producer = new UDPProducer();
        producer.host = cargs.getHost();
        producer.udpPort = cargs.getUdpPort();
        producer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        producer.dname = cargs.getDestination();
        UdpClient bk = new UdpClient(producer.host, producer.udpPort);
        Thread.sleep(500L);
        producer.sendLoop(bk, cargs.getMessageLength());
    }

    private void sendLoop(UdpClient bk, int messageLength) throws Throwable {
        for (int i = 0; i < 1000000; ++i) {
            String msg = RandomStringUtils.randomAlphanumeric((int)messageLength);
            NetBrokerMessage brokerMessage = new NetBrokerMessage(msg.getBytes("UTF-8"));
            NetPublish publishMsg = new NetPublish(this.dname, this.dtype, brokerMessage);
            bk.publish(publishMsg);
            System.out.printf("%s -> Destination: '%s#%s';  Message: '%s'%n", i, this.dtype, this.dname, msg);
            Sleep.time((long)500L);
        }
    }
}

