/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.concurrent.CountDownLatch;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.performance.TestActor;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class Consumer
extends TestActor {
    private final NetAction.DestinationType destinationType;
    private final int numberOfMsgToReceive;
    private CountDownLatch countDown;

    public Consumer(BrokerClient bkCLient, NetAction.DestinationType destinationType, int numberOfMsgToReceive) {
        super(bkCLient);
        this.destinationType = destinationType;
        this.numberOfMsgToReceive = numberOfMsgToReceive;
    }

    public void init() throws Exception {
        this.countDown = new CountDownLatch(this.numberOfMsgToReceive);
        NetSubscribe subscribe = new NetSubscribe("/test/foo", this.destinationType);
        try {
            this.getBrokerClient().addAsyncConsumer(subscribe, (BrokerListener)this);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    @Override
    public Integer call() throws Exception {
        this.countDown.await();
        return new Integer(0);
    }

    public boolean isAutoAck() {
        return this.destinationType != NetAction.DestinationType.TOPIC;
    }

    public void onMessage(NetNotification message) {
        this.countDown.countDown();
    }
}

