/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import pt.com.broker.performance.Test;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;

public class Main {
    private static final NetAction.DestinationType[] destinationTypes = new NetAction.DestinationType[]{NetAction.DestinationType.QUEUE};
    private static final NetProtocolType[] protocolTypes = new NetProtocolType[]{NetProtocolType.PROTOCOL_BUFFER};
    private static final int[] messageSizes = new int[]{10, 200000};
    private static final int[][] clients = new int[][]{{1, 0, 0}, {4, 0, 0}};

    public static void main(String[] args) {
        for (NetAction.DestinationType destinationType : destinationTypes) {
            for (int messageSize : messageSizes) {
                for (NetProtocolType protocolType : protocolTypes) {
                    System.out.println(String.format("[ %s | %s | %s]", destinationType, protocolType, messageSize));
                    System.out.println("----------------------------------------------------------------------------------------------------------------------------");
                    for (int index = 0; index != clients.length; ++index) {
                        double nano2second = 1.0E9;
                        Test test = new Test(destinationType, protocolType, messageSize, clients[index][0], clients[index][1], clients[index][2]);
                        double nanos = test.run();
                        double totalNrOfMessagesSent = test.getNrOfMessages() * clients[index][0];
                        double timePerMsg = nanos / totalNrOfMessagesSent / nano2second;
                        double messagesPerSecond = 1.0 / timePerMsg;
                        String result = String.format("--------> Producers: %s, Local Consumers: %s, Remote Consumers: %s. Messages: %s.Time: %s (s). Time per message: %s (s). Messages per second: %s\n", clients[index][0], clients[index][1], clients[index][2], totalNrOfMessagesSent, nanos / nano2second, timePerMsg, messagesPerSecond);
                        System.out.println(result);
                    }
                }
            }
        }
        System.out.println("Done!");
    }
}

