/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class PollPerformanceTestV1 {
    private static String hostname = "localhost";
    private static int port = 3323;
    private static final int NUMBER_OF_CONSUMERS = 128;
    private static final int MESSAGES_PRODUCED = 1500;
    private static final String QUEUE_NAME = "/queue/performance";
    private static boolean produceBefore = true;
    private static Object producingSynObj = new Object();
    private static volatile long initTime = 0L;
    private static AtomicInteger messagesReceived = new AtomicInteger(0);
    private static volatile long endTime = 0L;
    private static Object endSyncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("Test starting!");
        new Producer().start();
        int consumerCount = 128;
        while (consumerCount-- != 0) {
            new Consumer().start();
        }
        Object object = endSyncObj;
        synchronized (object) {
            try {
                endSyncObj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("  Test Ended!");
        System.out.println("     Messages produced: 1500");
        System.out.println("     Number of consumer: 128");
        System.out.println("     Time (in milliseconds): " + (endTime - initTime) / 1000000L);
    }

    public static class AsynConsumer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("AsynConsumer Thread started");
            Object endObj = new Object();
            BrokerClient bk = null;
            try {
                bk = new BrokerClient(hostname, port);
                if (produceBefore) {
                    Object object = producingSynObj;
                    synchronized (object) {
                        producingSynObj.wait();
                    }
                }
                if (initTime == 0L) {
                    initTime = System.nanoTime();
                }
                try {
                    NetSubscribe subscribe = new NetSubscribe(PollPerformanceTestV1.QUEUE_NAME, NetAction.DestinationType.QUEUE);
                    BrokerListener listener = new BrokerListener(){

                        public boolean isAutoAck() {
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onMessage(NetNotification message) {
                            long currentCount = messagesReceived.addAndGet(1);
                            if (currentCount % 50L == 0L) {
                                System.out.println(currentCount);
                            }
                            if (currentCount == 1500L) {
                                endTime = System.nanoTime();
                                System.out.println("Consumer Thread ended (limit reached). ");
                                Object object = endSyncObj;
                                synchronized (object) {
                                    endSyncObj.notifyAll();
                                }
                                return;
                            }
                        }
                    };
                    bk.addAsyncConsumer(subscribe, listener);
                    Object object = endObj;
                    synchronized (object) {
                        endObj.wait();
                    }
                    bk.close();
                }
                catch (TimeoutException te) {
                    if (messagesReceived.addAndGet(0) >= 1500) {
                        System.out.println("Consumer Thread ended (timeout).");
                        bk.close();
                        return;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                bk.close();
                System.out.println("Consumer Thread ended (exception):");
                return;
            }
        }
    }

    public static class Consumer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            System.out.println("Consumer Thread started");
            messagesReceivedByThread = 0;
            pollTimeAcc = 0L;
            timeAccCount = 0;
            bk = null;
            try {
                bk = new BrokerClient(PollPerformanceTestV1.access$000(), PollPerformanceTestV1.access$100());
                if (PollPerformanceTestV1.access$200()) {
                    var6_5 = PollPerformanceTestV1.access$300();
                    synchronized (var6_5) {
                        PollPerformanceTestV1.access$300().wait();
                    }
                }
                if (PollPerformanceTestV1.access$400() == 0L) {
                    PollPerformanceTestV1.access$402(System.nanoTime());
                }
                while (PollPerformanceTestV1.access$500().get() != 1500) {
                    block31: {
                        initNanoTime = System.nanoTime();
                        poll = bk.poll("/queue/performance", -1L, null);
                        endNanoTime = System.nanoTime();
                        pollTimeAcc += endNanoTime - initNanoTime;
                        ++timeAccCount;
                        if (poll == null) ** GOTO lbl51
                        bk.acknowledge(poll);
                        currentCount = PollPerformanceTestV1.access$500().addAndGet(1);
                        ++messagesReceivedByThread;
                        if (currentCount % 50L == 0L) {
                            System.out.println(currentCount);
                        }
                        if (currentCount != 1500L) break block31;
                        PollPerformanceTestV1.access$602(System.nanoTime());
                        if (timeAccCount != 0) {
                            System.out.println("Consumer Thread ended (limit reached). Average:" + pollTimeAcc / (long)timeAccCount);
                        } else {
                            System.out.println("Consumer Thread ended (limit reached). No messages received");
                        }
                        var13_13 = PollPerformanceTestV1.access$700();
                        synchronized (var13_13) {
                            PollPerformanceTestV1.access$700().notifyAll();
                        }
                        bk.close();
                        return;
                    }
                    try {
                        continue;
lbl51:
                        // 1 sources

                        if (timeAccCount != 0) {
                            System.out.println("Consumer Thread ended (null message). Average:" + pollTimeAcc / (long)timeAccCount);
                        } else {
                            System.out.println("Consumer Thread ended (null message).  No messages received.");
                        }
                        bk.close();
                        return;
                    }
                    catch (TimeoutException te) {
                        if (PollPerformanceTestV1.access$500().addAndGet(0) >= 1500) {
                            if (timeAccCount != 0) {
                                System.out.println("Consumer Thread ended (timeout). Average:" + pollTimeAcc / (long)timeAccCount);
                            } else {
                                System.out.println("Consumer Thread ended (timeout). No messages received");
                            }
                            bk.close();
                            if (timeAccCount != 0) {
                                System.out.println("Consumer Thread ended (finally). Average:" + pollTimeAcc / (long)timeAccCount);
                            } else {
                                System.out.println("Consumer Thread ended (finally).  No messages received.");
                            }
                            bk.close();
                            return;
                        }
                        try {
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            return;
                        }
                        catch (Throwable var15_15) {
                            throw var15_15;
                            return;
                        }
                    }
                }
            }
            finally {
                if (timeAccCount != 0) {
                    System.out.println("Consumer Thread ended (finally). Average:" + pollTimeAcc / (long)timeAccCount);
                } else {
                    System.out.println("Consumer Thread ended (finally).  No messages received.");
                }
                bk.close();
            }
        }
    }

    public static class Producer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Producer Thread started");
            try {
                BrokerClient bk = new BrokerClient(hostname, port);
                int count = 1500;
                NetBrokerMessage brokerMessage = new NetBrokerMessage("This is a test!");
                while (count-- != 0) {
                    bk.enqueueMessage(brokerMessage, PollPerformanceTestV1.QUEUE_NAME);
                }
                if (produceBefore) {
                    Object object = producingSynObj;
                    synchronized (object) {
                        producingSynObj.notifyAll();
                    }
                }
                bk.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            System.out.println("Producer Thread ended");
        }
    }
}

