/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.text.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.performance.TestCliArgs;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;

public class ProducerApp {
    public static final byte STOP_MESSAGE = 0;
    public static final byte REGULAR_MESSAGE = 1;
    private static final ExecutorService executer = Executors.newFixedThreadPool(16);
    private static final Logger log = LoggerFactory.getLogger(ProducerApp.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    private AtomicInteger threadsWorking;
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;

    public static void main(String[] args) throws Throwable {
        final TestCliArgs cargs = (TestCliArgs)CliFactory.parseArguments(TestCliArgs.class, (String[])args);
        final ProducerApp producer = new ProducerApp();
        producer.host = cargs.getHost();
        producer.port = cargs.getPort();
        producer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        producer.dname = cargs.getDestination();
        final BrokerClient bk = new BrokerClient(producer.host, producer.port, "tcp://mycompany.com/mypublisher");
        Thread.sleep(200L);
        int producingThreads = cargs.getProducingThreads();
        log.info("Start sending " + cargs.getNumberOfMessages() + " strings of " + cargs.getMessageLength() + " random alphanumeric characters in 200 milliseconds to " + producer.dname + " using " + producingThreads + " threads.");
        final int messagesPerThread = cargs.getNumberOfMessages() / producingThreads;
        ArrayList<1> producers = new ArrayList<1>(producingThreads);
        for (int i = 0; i != producingThreads; ++i) {
            producers.add(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    try {
                        producer.sendLoop(bk, cargs.getMessageLength(), messagesPerThread, cargs.getNumberOfMessages());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        producer.threadsWorking = new AtomicInteger(producingThreads);
        executer.invokeAll(producers);
        System.out.println("Done!");
        System.exit(0);
    }

    private void sendLoop(BrokerClient bk, int messageLength, int nrOfMessages, int totalMessages) throws Throwable {
        int i;
        String regularMsgContent = RandomStringUtils.randomAlphanumeric((int)(messageLength - 1));
        String stopMsgContent = totalMessages + "";
        byte[] regularMessage = this.getMessage((byte)1, regularMsgContent);
        byte[] stopMessage = this.getMessage((byte)0, stopMsgContent);
        NetBrokerMessage brokerMessage = new NetBrokerMessage(regularMessage);
        NetBrokerMessage stopBrokerMessage = new NetBrokerMessage(stopMessage);
        for (i = 0; i != nrOfMessages; ++i) {
            if (this.dtype == NetAction.DestinationType.QUEUE) {
                bk.enqueueMessage(brokerMessage, this.dname);
                continue;
            }
            bk.publishMessage(brokerMessage, this.dname);
        }
        if (this.threadsWorking.decrementAndGet() == 0) {
            System.out.println("Sending stop messages");
            for (i = 0; i != 10; ++i) {
                if (this.dtype == NetAction.DestinationType.QUEUE) {
                    bk.enqueueMessage(stopBrokerMessage, this.dname);
                    continue;
                }
                bk.publishMessage(stopBrokerMessage, this.dname);
            }
            bk.close();
        }
    }

    private byte[] getMessage(byte headerByte, String messageContent) {
        byte[] serializedContent = new byte[]{};
        try {
            serializedContent = messageContent.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        byte[] serializedMessage = new byte[serializedContent.length + 1];
        serializedMessage[0] = headerByte;
        System.arraycopy(serializedContent, 0, serializedMessage, 1, serializedContent.length);
        return serializedMessage;
    }
}

