/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.caudexorigo.text.RandomStringUtils;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.performance.Consumer;
import pt.com.broker.performance.Producer;
import pt.com.broker.performance.TestActor;
import pt.com.broker.performance.conf.ConfigurationInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;

public class Test {
    private static int defaultNrOfMessages = 10000;
    private static final ExecutorService executer = Executors.newFixedThreadPool(16);
    private int nrOfMessages = Test.getDefaultNrOfMessages();
    private final NetAction.DestinationType destinationType;
    private final NetProtocolType protocolType;
    private final int messageSize;
    private final int nrProducers;
    private final int nrLocalConsumers;
    private final int nrRemoteConsumers;
    private static final String localAgentAddress;
    private static final int localAgentPort;
    private static final String remotAgentAddress;
    private static final int remoteAgentPort;

    public Test(NetAction.DestinationType destinationType, NetProtocolType protocolType, int messageSize, int nrProducers, int nrLocalConsumers, int nrRemoteConsumers) {
        this.destinationType = destinationType;
        this.protocolType = protocolType;
        this.messageSize = messageSize;
        this.nrProducers = nrProducers;
        this.nrLocalConsumers = nrLocalConsumers;
        this.nrRemoteConsumers = nrRemoteConsumers;
    }

    public long run() {
        Consumer consumer;
        BrokerClient bk;
        int i;
        String msg = RandomStringUtils.randomAlphanumeric((int)this.messageSize);
        int totalConsumers = this.nrLocalConsumers + this.nrRemoteConsumers;
        int msgPerClient = this.getNrOfMessages();
        if (this.destinationType == NetAction.DestinationType.QUEUE) {
            if (totalConsumers == 0) {
                msgPerClient = 0;
            } else {
                if (this.getNrOfMessages() % totalConsumers != 0) {
                    throw new RuntimeException("The number of messages consumers must be multiple of the total number of consumers!");
                }
                msgPerClient = this.getNrOfMessages() / totalConsumers;
            }
        }
        ArrayList<TestActor> clients = new ArrayList<TestActor>(totalConsumers + this.nrProducers);
        for (i = 0; i != this.nrLocalConsumers; ++i) {
            try {
                bk = new BrokerClient(localAgentAddress, localAgentPort, "test app", this.protocolType);
                consumer = new Consumer(bk, this.destinationType, msgPerClient);
                consumer.init();
                clients.add(consumer);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i != this.nrRemoteConsumers; ++i) {
            try {
                bk = new BrokerClient(remotAgentAddress, remoteAgentPort, "test app", this.protocolType);
                consumer = new Consumer(bk, this.destinationType, msgPerClient);
                consumer.init();
                clients.add(consumer);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i != this.nrProducers; ++i) {
            try {
                bk = new BrokerClient(localAgentAddress, localAgentPort, "test app", this.protocolType);
                Producer producer = new Producer(bk, this.destinationType, this.getNrOfMessages(), msg);
                clients.add(producer);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        long start = System.nanoTime();
        try {
            executer.invokeAll(clients, 5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long execTime = System.nanoTime() - start;
        for (TestActor testActor : clients) {
            testActor.close();
        }
        return execTime;
    }

    public void setNrOfMessages(int nrOdMessages) {
        this.nrOfMessages = nrOdMessages;
    }

    public int getNrOfMessages() {
        return this.nrOfMessages;
    }

    public static void setDefaultNrOdMessages(int nrOdMessages) {
        defaultNrOfMessages = nrOdMessages;
    }

    public static int getDefaultNrOfMessages() {
        return defaultNrOfMessages;
    }

    static {
        ConfigurationInfo.init();
        localAgentAddress = ConfigurationInfo.getParameter("agent1-host");
        localAgentPort = Integer.parseInt(ConfigurationInfo.getParameter("agent1-port"));
        remotAgentAddress = ConfigurationInfo.getParameter("agent2-host");
        remoteAgentPort = Integer.parseInt(ConfigurationInfo.getParameter("agent2-port"));
    }
}

