/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.caudexorigo.cli.CliFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.performance.TestCliArgs;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class ConsumerApp
implements BrokerListener {
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;
    private CountDownLatch countDown = new CountDownLatch(1);
    volatile int sentMessages;
    AtomicLong startTime = new AtomicLong(0L);
    volatile long stopTime;
    AtomicInteger counter = new AtomicInteger(0);

    public static void main(String[] args) throws Throwable {
        TestCliArgs cargs = (TestCliArgs)CliFactory.parseArguments(TestCliArgs.class, (String[])args);
        ConsumerApp consumer = new ConsumerApp();
        consumer.host = cargs.getHost();
        consumer.port = cargs.getPort();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        BrokerClient bk = new BrokerClient(consumer.host, consumer.port, "tcp://mycompany.com/mysniffer");
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        bk.addAsyncConsumer(subscribe, (BrokerListener)consumer);
        System.out.println("Waiting...");
        consumer.countDown.await();
        bk.close();
        System.out.println(String.format("Received messages: %s, Sent messages: %s", consumer.counter.get() + "", consumer.sentMessages + ""));
        System.out.println(String.format("Time: %s (ns)", consumer.stopTime - consumer.startTime.get() + ""));
        double nano2second = 1.0E9;
        double time = (double)consumer.stopTime - (double)consumer.startTime.get();
        double totalNrOfMessagesSent = consumer.sentMessages;
        double timePerMsg = time / totalNrOfMessagesSent / nano2second;
        double messagesPerSecond = 1.0 / timePerMsg;
        String result = String.format("--------> Messages: %s.Time: %s (s). Time per message: %s (s). Messages per second: %s\n", (int)totalNrOfMessagesSent, time / nano2second, timePerMsg, messagesPerSecond);
        System.out.println(result);
    }

    public boolean isAutoAck() {
        return this.dtype != NetAction.DestinationType.TOPIC;
    }

    public void onMessage(NetNotification notification) {
        if (!this.startTime.compareAndSet(0L, System.nanoTime())) {
            if (notification.getMessage().getPayload()[0] == 0) {
                this.stopTime = System.nanoTime();
                byte[] payload = notification.getMessage().getPayload();
                byte[] serializedCount = new byte[payload.length - 1];
                System.arraycopy(payload, 1, serializedCount, 0, serializedCount.length);
                String sentMessagesStr = new String(serializedCount);
                this.sentMessages = Integer.parseInt(sentMessagesStr);
                this.countDown.countDown();
            } else {
                int localCounter = this.counter.incrementAndGet();
                if (localCounter % 100 == 0) {
                    System.out.println("Messages received: " + localCounter);
                }
            }
        } else {
            this.counter.incrementAndGet();
            System.out.println("First message received!");
        }
    }
}

