/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.Shutdown;
import pt.com.broker.performance.QueueProducer;
import pt.com.broker.performance.SyncConsumerClientV2;

public class PollPerformanceTestV2 {
    private static String hostname = "localhost";
    private static int port = 3323;
    private static final int NUMBER_OF_CONSUMERS = 32;
    private static final int MESSAGES_PRODUCED = 1500;
    private static final String QUEUE_NAME = "/queue/performance";

    public static void main(String[] args) throws Throwable {
        CountDownLatch cdp = new CountDownLatch(1);
        QueueProducer qp = new QueueProducer(1500, hostname, port, QUEUE_NAME, cdp);
        qp.run();
        cdp.await();
        CountDownLatch cdc = new CountDownLatch(32);
        ExecutorService exec = Executors.newFixedThreadPool(32);
        AtomicInteger counter = new AtomicInteger(1500);
        double start = System.nanoTime();
        for (int i = 0; i < 32; ++i) {
            SyncConsumerClientV2 sc = new SyncConsumerClientV2(counter, "Client#" + i, hostname, port, QUEUE_NAME, cdc);
            exec.execute(sc);
        }
        cdc.await();
        double stop = System.nanoTime();
        double elapsed = (stop - start) / 1.0E9;
        System.out.println("Test Ended!");
        System.out.println("Messages produced: 1500");
        System.out.println("Number of consumer: 32");
        System.out.println("Time (in seconds): " + elapsed);
        Shutdown.now();
    }
}

