/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import pt.com.broker.client.BrokerClient;
import pt.com.broker.performance.TestActor;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetNotification;

public class Producer
extends TestActor {
    private final NetAction.DestinationType destinationType;
    private final int numberOfMsgToSend;
    private final String message;

    public Producer(BrokerClient bkCLient, NetAction.DestinationType destinationType, int numberOfMsgToSend, String message) {
        super(bkCLient);
        this.destinationType = destinationType;
        this.numberOfMsgToSend = numberOfMsgToSend;
        this.message = message;
    }

    @Override
    public Integer call() throws Exception {
        NetBrokerMessage message = new NetBrokerMessage(this.message.getBytes());
        String destination = "/test/foo";
        if (this.destinationType == NetAction.DestinationType.QUEUE) {
            for (int i = this.numberOfMsgToSend; i != 0; --i) {
                this.getBrokerClient().enqueueMessage(message, destination);
            }
        } else {
            for (int i = this.numberOfMsgToSend; i != 0; --i) {
                this.getBrokerClient().publishMessage(message, destination);
            }
        }
        return new Integer(0);
    }

    public boolean isAutoAck() {
        return false;
    }

    public void onMessage(NetNotification message) {
    }
}

