/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.types.NetNotification;

public class SyncConsumerClient
implements Runnable {
    private AtomicInteger counter;
    private String clientId;
    private String host;
    private int port;
    private final String queueName;
    private final CountDownLatch countDown;
    private static AtomicInteger clientsEnded = new AtomicInteger(0);

    public SyncConsumerClient(AtomicInteger counter, String clientId, String host, int port, String queueName, CountDownLatch countDown) {
        this.counter = counter;
        this.clientId = clientId;
        this.host = host;
        this.port = port;
        this.queueName = queueName;
        this.countDown = countDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.printf("SyncConsumerClient '%s' started%n", this.clientId);
        long pollTimeAcc = 0L;
        int timeAccCount = 0;
        BrokerClient bk = null;
        try {
            bk = new BrokerClient(this.host, this.port);
            while (this.counter.get() > 0) {
                long initNanoTime = System.nanoTime();
                NetNotification poll = bk.poll(this.queueName, -1L, null);
                long endNanoTime = System.nanoTime();
                pollTimeAcc += endNanoTime - initNanoTime;
                ++timeAccCount;
                if (poll == null) continue;
                bk.acknowledge(poll);
                long currentCount = this.counter.decrementAndGet();
                if (currentCount % 50L != 0L) continue;
                System.out.println(currentCount);
            }
            double v = pollTimeAcc / (long)timeAccCount / 1000000L;
            if (timeAccCount != 0) {
                System.out.printf("SyncConsumerClient '%s' ended. Average latency:%4.2fms %n", this.clientId, v);
            } else {
                System.out.printf("SyncConsumerClient '%s' ended. No messages received", new Object[0]);
            }
        }
        catch (TimeoutException ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (bk != null) {
                bk.close();
            }
            this.countDown.countDown();
        }
    }
}

