/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance.distributed;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;

public class DistTestParams {
    private static final Logger log = LoggerFactory.getLogger(DistTestParams.class);
    private String testName;
    private String destination;
    private NetAction.DestinationType destinationType;
    private int messageSize;
    private int numberOfMessagesToSend;
    private boolean syncConsumer;
    private boolean isNoAckConsumer;
    private NetProtocolType encoding;
    private ClientInfo clientInfo;
    private final HashMap<String, ClientInfo> producers = new HashMap();
    private final HashMap<String, ClientInfo> consumers = new HashMap();

    private DistTestParams() {
    }

    public DistTestParams(String testName, String destination, NetAction.DestinationType destinationType, int messageSize, int numberOfMessagesToSend, boolean syncConsumer, boolean isNoAckConsumer, NetProtocolType encoding) {
        this.testName = testName;
        this.destination = destination;
        this.destinationType = destinationType;
        this.messageSize = messageSize;
        this.numberOfMessagesToSend = numberOfMessagesToSend;
        this.syncConsumer = syncConsumer;
        this.isNoAckConsumer = isNoAckConsumer;
        this.encoding = encoding;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getDestination() {
        return this.destination;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public int getNumberOfMessagesToSend() {
        return this.numberOfMessagesToSend;
    }

    public HashMap<String, ClientInfo> getProducers() {
        return this.producers;
    }

    public HashMap<String, ClientInfo> getConsumers() {
        return this.consumers;
    }

    public boolean isSyncConsumer() {
        return this.syncConsumer;
    }

    public boolean isNoAckConsumer() {
        return this.isNoAckConsumer;
    }

    public NetProtocolType getEncoding() {
        return this.encoding;
    }

    public byte[] serialize(ClientInfo clientInfo) {
        byte[] data = null;
        try {
            UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream();
            ObjectOutputStream outputObj = new ObjectOutputStream((OutputStream)bout);
            outputObj.writeUTF(this.testName);
            outputObj.writeUTF(this.destination);
            outputObj.writeUTF(this.destinationType.toString());
            outputObj.writeInt(this.messageSize);
            outputObj.writeInt(this.numberOfMessagesToSend);
            outputObj.writeBoolean(this.syncConsumer);
            outputObj.writeBoolean(this.isNoAckConsumer);
            outputObj.writeUTF(this.encoding.toString());
            clientInfo.write(outputObj);
            outputObj.flush();
            data = bout.toByteArray();
        }
        catch (IOException e) {
            log.error("Failed to serialize object", (Throwable)e);
        }
        return data;
    }

    public static DistTestParams deserialize(byte[] data) {
        DistTestParams distTestParams = new DistTestParams();
        try {
            ObjectInputStream inputObj = new ObjectInputStream((InputStream)new UnsynchronizedByteArrayInputStream(data));
            distTestParams.testName = inputObj.readUTF();
            distTestParams.destination = inputObj.readUTF();
            distTestParams.destinationType = NetAction.DestinationType.valueOf((String)inputObj.readUTF());
            distTestParams.messageSize = inputObj.readInt();
            distTestParams.numberOfMessagesToSend = inputObj.readInt();
            distTestParams.syncConsumer = inputObj.readBoolean();
            distTestParams.isNoAckConsumer = inputObj.readBoolean();
            distTestParams.encoding = NetProtocolType.valueOf((String)inputObj.readUTF());
            distTestParams.clientInfo = new ClientInfo();
            distTestParams.clientInfo.read(inputObj);
        }
        catch (Throwable e) {
            log.error("Failed to deserialize object", e);
            return null;
        }
        return distTestParams;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public static class ClientInfo {
        private String name;
        private String agentHost;
        private int port;

        private ClientInfo() {
        }

        public ClientInfo(String name, String agentHost, int port) {
            this.name = name;
            this.agentHost = agentHost;
            this.port = port;
        }

        public String getName() {
            return this.name;
        }

        public String getAgentHost() {
            return this.agentHost;
        }

        public int getPort() {
            return this.port;
        }

        public void write(ObjectOutputStream outputObj) {
            try {
                outputObj.writeUTF(this.name);
                outputObj.writeUTF(this.agentHost);
                outputObj.writeInt(this.port);
            }
            catch (IOException e) {
                log.error("Failed to serialize object", (Throwable)e);
            }
        }

        public void read(ObjectInputStream inputObj) {
            try {
                this.name = inputObj.readUTF();
                this.agentHost = inputObj.readUTF();
                this.port = inputObj.readInt();
            }
            catch (Throwable e) {
                log.error("Failed to deserialize object", e);
            }
        }
    }
}

