/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance.distributed;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResult {
    private static final Logger log = LoggerFactory.getLogger(TestResult.class);
    private ActorType actorType;
    private String actorName;
    private String testName;
    private int messages;
    private long startTime;
    private long stopTime;

    private TestResult() {
    }

    public TestResult(ActorType actorType, String actorName, String testName, int messages, long startTime, long stopTime) {
        this.actorType = actorType;
        this.actorName = actorName;
        this.testName = testName;
        this.messages = messages;
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public TestResult(ActorType actorType, String actorName, String testName) {
        this.actorType = actorType;
        this.actorName = actorName;
        this.testName = testName;
        this.messages = -1;
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public ActorType getActorType() {
        return this.actorType;
    }

    public String getActorName() {
        return this.actorName;
    }

    public String getTestName() {
        return this.testName;
    }

    public int getMessages() {
        return this.messages;
    }

    public void setMessages(int messages) {
        this.messages = messages;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public double getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public byte[] serialize() {
        byte[] data = null;
        try {
            UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream();
            ObjectOutputStream outputObj = new ObjectOutputStream((OutputStream)bout);
            outputObj.writeUTF(this.testName);
            outputObj.writeUTF(this.actorName);
            outputObj.writeUTF(this.actorType.toString());
            outputObj.writeInt(this.messages);
            outputObj.writeLong(this.startTime);
            outputObj.writeLong(this.stopTime);
            outputObj.flush();
            data = bout.toByteArray();
        }
        catch (IOException e) {
            log.error("Failed to serialize object", (Throwable)e);
        }
        return data;
    }

    public static TestResult deserialize(byte[] data) {
        TestResult testResult = new TestResult();
        try {
            ObjectInputStream inputObj = new ObjectInputStream((InputStream)new UnsynchronizedByteArrayInputStream(data));
            testResult.testName = inputObj.readUTF();
            testResult.actorName = inputObj.readUTF();
            testResult.actorType = ActorType.valueOf(inputObj.readUTF());
            testResult.messages = inputObj.readInt();
            testResult.startTime = inputObj.readLong();
            testResult.stopTime = inputObj.readLong();
        }
        catch (Throwable e) {
            log.error("Failed to deserialize object", e);
            return null;
        }
        return testResult;
    }

    public static enum ActorType {
        Procucer,
        Consumer;

    }
}

