/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.performance.distributed.conf;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.performance.distributed.conf.Agents;
import pt.com.broker.performance.distributed.conf.TestConfiguration;
import pt.com.broker.types.NetProtocolType;

public class ConfigurationInfo {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationInfo.class);
    private static TestConfiguration configuration;
    private static HashMap<String, AgentInfo> agents;
    private static AgentInfo defaultAgent;

    private static void loadAgents() {
        if (ConfigurationInfo.getConfiguration() == null) {
            Shutdown.now();
        }
        Agents agents = ConfigurationInfo.getConfiguration().getAgents();
        List<Agents.Agent> agentList = agents.getAgent();
        for (Agents.Agent agent : agentList) {
            ConfigurationInfo.getAgents().put(agent.getAgentId(), new AgentInfo(agent.getAgentId(), agent.getHostname(), agent.getTcpPort().intValue(), agent.getHttpPort().intValue()));
        }
        defaultAgent = ConfigurationInfo.getAgents().get(agents.getDefaultAgent());
    }

    public static void init() {
        ConfigurationInfo.loadAgents();
    }

    public static HashMap<String, AgentInfo> getAgents() {
        return agents;
    }

    public static TestConfiguration getConfiguration() {
        return configuration;
    }

    public static AgentInfo getDefaultAgent() {
        return defaultAgent;
    }

    public static NetProtocolType getEncoding() {
        String encoding = configuration.getTests().getEncoding();
        return NetProtocolType.valueOf((String)encoding);
    }

    static {
        agents = new HashMap();
        Unmarshaller u = null;
        try {
            File f;
            boolean b;
            JAXBContext jc = JAXBContext.newInstance((String)"pt.com.broker.performance.distributed.conf");
            u = jc.createUnmarshaller();
            String filename = System.getProperty("perf-test-configuration");
            if (filename == null) {
                log.error("Property 'perf-test-configuration' not defined. Exiting...");
                Shutdown.now();
            }
            if (!(b = (f = new File(filename)).exists())) {
                log.error("Configuration file (" + filename + ") was not found.");
            }
            configuration = (TestConfiguration)u.unmarshal(f);
        }
        catch (Throwable e) {
            log.error("Configuration initialization failed.", e);
        }
    }

    public static class AgentInfo {
        public final String id;
        public final String hostname;
        public final int tcpPort;
        public final int httpPort;

        AgentInfo(String id, String hostname, int tcpPort, int httpPort) {
            this.id = id;
            this.hostname = hostname;
            this.tcpPort = tcpPort;
            this.httpPort = httpPort;
        }
    }
}

