/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.functests.Action;
import pt.com.broker.functests.BaseTest;
import pt.com.broker.functests.Consequence;
import pt.com.broker.functests.Epilogue;
import pt.com.broker.functests.Prerequisite;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.TestsResults;

public abstract class Test
extends BaseTest {
    private static final Logger log = LoggerFactory.getLogger(Test.class);
    private static final ExecutorService executer = Executors.newFixedThreadPool(8);
    private String name;
    private boolean okToTimeOut = false;
    private List<Prerequisite> prerequisites = new ArrayList<Prerequisite>();
    private Action action;
    private List<Consequence> consequences = new ArrayList<Consequence>();
    private List<Epilogue> epilogues = new ArrayList<Epilogue>();
    private static long defaultTimeout = Test.getDefaultTimeout();
    private long timeout = Test.getDefaultTimeout();
    private boolean skipTest = false;

    public Test(String name) {
        this.name = name;
    }

    protected void addPrerequisite(Prerequisite prerequisite) {
        this.getPrerequisites().add(prerequisite);
    }

    protected void setAction(Action action) {
        this.action = action;
    }

    protected void addConsequences(Consequence consequence) {
        this.getConsequences().add(consequence);
    }

    protected void addEpilogue(Epilogue epilogue) {
        this.getEpilogues().add(epilogue);
    }

    protected abstract void build() throws Throwable;

    protected void logBuildTest() {
        log.info(String.format("Building test - %s ", this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean run(int nrOfRuns, TestsResults testResults) {
        boolean result = true;
        if (this.skipTest()) {
            testResults.addSkipedTest(this.getNameAndEncoding(testResults));
            return true;
        }
        try {
            this.logBuildTest();
            this.build();
            log.info("Initializing  test - " + this.getName());
            for (Prerequisite prerequisite : this.getPrerequisites()) {
                prerequisite.call();
            }
            log.info("Performing test - " + this.getName());
            ArrayList<Step> activities = new ArrayList<Step>(this.getConsequences().size() + 1);
            activities.add(this.getAction());
            activities.addAll(this.getConsequences());
            int count = nrOfRuns;
            do {
                log.info("Timeout: " + this.getTimeout());
                List list = executer.invokeAll(activities, this.getTimeout(), TimeUnit.MILLISECONDS);
                for (Future executionResult : list) {
                    Step step = (Step)executionResult.get();
                    if (executionResult.isDone()) {
                        if (step.isSucess()) {
                            log.info("Successfull step - " + step.getName());
                            continue;
                        }
                        log.info("##### :( ##### Unsuccessfull step - " + step.getName() + " Reason: " + step.getReaseonForFailure());
                        result = false;
                        continue;
                    }
                    log.info("##### :( ##### Step didn't complete - " + step.getName());
                }
            } while (--count != 0);
        }
        catch (Throwable t) {
            try {
                if (!this.okToTimeOut() && this.getAction() != null) {
                    log.error(t.getMessage(), t);
                    if (!this.getAction().isSucess()) {
                        System.out.println(String.format(">>>> Action failed. Reason: %s", this.getAction().getReaseonForFailure()));
                    }
                    for (Consequence consequence : this.getConsequences()) {
                        if (consequence.isSucess()) continue;
                        System.out.println(String.format(">>>> Consequence '%s' failed. Reason: %s", consequence.getName(), consequence.getReaseonForFailure()));
                    }
                }
                if (t instanceof CancellationException && this.okToTimeOut()) {
                    result = true;
                }
                log.error("##### :( ##### Test " + this.getName() + " failed!", t);
                result = false;
                return result;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                log.info("Finalizing test - " + this.getName());
                for (Epilogue epilogue : this.getEpilogues()) {
                    try {
                        if (epilogue.call().isSucess()) continue;
                        log.error("Epilogue step failed test without exception. Name: " + epilogue.getName());
                    }
                    catch (Throwable t2) {
                        log.error("Epilogue step failed test with exception. Name: " + epilogue.getName(), t2);
                    }
                }
            }
        }
        log.info("Finalizing test - " + this.getName());
        for (Epilogue epilogue : this.getEpilogues()) {
            try {
                if (epilogue.call().isSucess()) continue;
                log.error("Epilogue step failed test without exception. Name: " + epilogue.getName());
            }
            catch (Throwable t) {
                log.error("Epilogue step failed test with exception. Name: " + epilogue.getName(), t);
            }
        }
        if (result) {
            testResults.addPositiveTest();
        } else {
            testResults.addFailedTest(this.getNameAndEncoding(testResults));
        }
        this.end();
        return result;
    }

    protected void end() {
    }

    private String getNameAndEncoding(TestsResults testResults) {
        String encoding = testResults.getProperty("Encoding");
        if (encoding == null) {
            return this.getName();
        }
        return this.getName() + " : " + encoding;
    }

    public final boolean run(TestsResults testResults) {
        return this.run(1, testResults);
    }

    @org.junit.Test
    public final void run() {
        Boolean result = this.run(1, new TestsResults());
        Assert.assertTrue((boolean)result);
    }

    public String getName() {
        return this.name;
    }

    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public Action getAction() {
        return this.action;
    }

    public List<Consequence> getConsequences() {
        return this.consequences;
    }

    private List<Epilogue> getEpilogues() {
        return this.epilogues;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static void setDefaultimeout(long timeout) {
        defaultTimeout = timeout;
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public void setSkipTest(boolean skipTest) {
        this.skipTest = skipTest;
    }

    public boolean skipTest() {
        return this.skipTest;
    }

    public void setOkToTimeOut(boolean okToTimeOut) {
        this.okToTimeOut = okToTimeOut;
    }

    public boolean okToTimeOut() {
        return this.okToTimeOut;
    }

    public void setName(String name) {
        this.name = name;
    }
}

