/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.util.Arrays;
import java.util.Collection;
import org.caudexorigo.text.RandomStringUtils;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.functests.Test;
import pt.com.broker.functests.conf.ConfigurationInfo;
import pt.com.broker.types.NetProtocolType;

@RunWith(value=Parameterized.class)
public abstract class BrokerTest
extends Test {
    private static final Logger log = LoggerFactory.getLogger(BrokerTest.class);
    private static NetProtocolType defaultEncodingProtocolType = NetProtocolType.PROTOCOL_BUFFER;
    private NetProtocolType encodingProtocolType;
    private boolean constructionFailed = false;
    private Throwable reasonForFailure;
    private static int defaultDataLenght = 200;
    protected int dataLenght = BrokerTest.getDefaultDataLenght();
    protected byte[] rawData = null;

    @Override
    protected void logBuildTest() {
        log.info(String.format("Building test - %s ( %s ) ", this.getName(), this.encodingProtocolType));
    }

    public BrokerTest(NetProtocolType protocolType) {
        super("");
        this.encodingProtocolType = protocolType;
    }

    public void setFailure(Throwable throwable) {
        this.setConstructionFailed(true);
        this.setReasonForFailure(throwable);
    }

    public void setEncodingProtocolType(NetProtocolType encodingProtocolType) {
        this.encodingProtocolType = encodingProtocolType;
    }

    public NetProtocolType getEncodingProtocolType() {
        return this.encodingProtocolType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultEncodingProtocolType(NetProtocolType defaultEncodingProtocolType) {
        NetProtocolType netProtocolType = defaultEncodingProtocolType;
        synchronized (netProtocolType) {
            BrokerTest.defaultEncodingProtocolType = defaultEncodingProtocolType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetProtocolType getDefaultEncodingProtocolType() {
        NetProtocolType netProtocolType = defaultEncodingProtocolType;
        synchronized (netProtocolType) {
            return defaultEncodingProtocolType;
        }
    }

    public void setConstructionFailed(boolean constructionFailed) {
        this.constructionFailed = constructionFailed;
    }

    public boolean isConstructionFailed() {
        return this.constructionFailed;
    }

    public void setReasonForFailure(Throwable reasonForFailure) {
        this.reasonForFailure = reasonForFailure;
    }

    public Throwable getReasonForFailure() {
        return this.reasonForFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(byte[] data) {
        BrokerTest brokerTest = this;
        synchronized (brokerTest) {
            this.rawData = data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        BrokerTest brokerTest = this;
        synchronized (brokerTest) {
            if (this.rawData == null) {
                this.rawData = RandomStringUtils.randomAlphanumeric((int)this.dataLenght).getBytes();
            }
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultDataLenght(int defaultDataLenght) {
        Class<BrokerTest> clazz = BrokerTest.class;
        synchronized (BrokerTest.class) {
            BrokerTest.defaultDataLenght = defaultDataLenght;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultDataLenght() {
        Class<BrokerTest> clazz = BrokerTest.class;
        synchronized (BrokerTest.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultDataLenght;
        }
    }

    public int getAgent1SSLPort() {
        return Integer.parseInt(ConfigurationInfo.getParameter("agent1-legacy-port"));
    }

    public int getAgent1Port() {
        int port = 0;
        port = this.encodingProtocolType.equals((Object)NetProtocolType.SOAP_v0) ? Integer.parseInt(ConfigurationInfo.getParameter("agent1-legacy-port")) : Integer.parseInt(ConfigurationInfo.getParameter("agent1-port"));
        return port;
    }

    public int getAgent2Port() {
        int port = 0;
        port = this.encodingProtocolType.equals((Object)NetProtocolType.SOAP_v0) ? Integer.parseInt(ConfigurationInfo.getParameter("agent2-legacy-port")) : Integer.parseInt(ConfigurationInfo.getParameter("agent2-port"));
        return port;
    }

    public int getAgent1UdpPort() {
        int port = 0;
        port = this.encodingProtocolType.equals((Object)NetProtocolType.SOAP_v0) ? Integer.parseInt(ConfigurationInfo.getParameter("agent1-legacy-udp-port")) : Integer.parseInt(ConfigurationInfo.getParameter("agent1-udp-port"));
        return port;
    }

    public int getAgent2UdpPort() {
        int port = 0;
        port = this.encodingProtocolType.equals((Object)NetProtocolType.SOAP_v0) ? Integer.parseInt(ConfigurationInfo.getParameter("agent2-legacy-udp-port")) : Integer.parseInt(ConfigurationInfo.getParameter("agent2-udp-port"));
        return port;
    }

    public String getAgent1Hostname() {
        return ConfigurationInfo.getParameter("agent1-host");
    }

    public String getAgent2Hostname() {
        return ConfigurationInfo.getParameter("agent2-host");
    }

    @Parameterized.Parameters
    public static Collection getProtocolTypes() {
        return Arrays.asList({NetProtocolType.JSON}, {NetProtocolType.PROTOCOL_BUFFER}, {NetProtocolType.THRIFT}, {NetProtocolType.SOAP}, {NetProtocolType.SOAP_v0});
    }
}

