/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import pt.com.broker.functests.Consequence;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.helpers.SetValueFuture;
import pt.com.broker.types.NetFault;

public class FaultConsequence
extends Consequence {
    private boolean okToTimeout = false;
    private String faultCode;
    private String faultMessage;
    private String faultDetail;
    private String actionId;
    private SetValueFuture<NetFault> future;

    public FaultConsequence(String name, String actorName, SetValueFuture<NetFault> future) {
        super(name, actorName);
        this.future = future;
    }

    @Override
    public Step run() throws Exception {
        try {
            NetFault fault = this.future.get();
            if (this.faultCode != null && !this.faultCode.equals(fault.getCode())) {
                String reason = String.format("Fault code mismatch! Expected: %s Received: %s", this.faultCode, fault.getCode());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.faultMessage != null && !this.faultMessage.equals(fault.getMessage())) {
                String reason = String.format("Fault message mismatch! Expected: %s Received: %s", this.faultMessage, fault.getMessage());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.faultDetail != null && !this.faultDetail.equals(fault.getDetail())) {
                String reason = String.format("Fault detail mismatch! Expected: %s Received: %s", this.faultDetail, fault.getDetail());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.actionId != null && !this.actionId.equals(fault.getActionId())) {
                String reason = String.format("Fault action id mismatch! Expected: %s Received: %s", this.actionId, fault.getActionId());
                this.setReasonForFailure(reason);
                return this;
            }
            this.setDone(true);
            this.setSucess(true);
        }
        catch (Throwable t) {
            System.out.println(String.format("FaultConsequence.run() failed. Name: '%s'. Actor name: '%s'. Reason: %s", this.getName(), this.getActorName(), t.getMessage()));
            this.setReasonForFailure(t.toString());
        }
        return this;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultMessage(String faultMessage) {
        this.faultMessage = faultMessage;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionId() {
        return this.actionId;
    }
}

