/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import io.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.ErrorListenerAdapter;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.Action;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.helpers.BrokerTest;
import pt.com.broker.functests.helpers.FaultConsequence;
import pt.com.broker.functests.helpers.SetValueFuture;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetProtocolType;

public class GenericNegativeTest
extends BrokerTest {
    private static final Logger log = LoggerFactory.getLogger(GenericNegativeTest.class);
    private BrokerClient brokerClient = null;
    private boolean okToTimeout = false;
    private BrokerListener defaultErrorListener = new ErrorListenerAdapter(){

        public void onMessage(NetFault message, HostInfo host) {
            log.info("Error Message Fault");
            GenericNegativeTest.this.faultFuture.set(message);
        }
    };
    private byte[] dataToSend = new byte[0];
    private SetValueFuture<NetFault> faultFuture = new SetValueFuture();
    private String faultCode = null;
    private String faultMessage = null;
    private String faultActionId = null;
    private String faultDetail = null;

    public GenericNegativeTest(NetProtocolType protocolType) {
        super(protocolType);
        try {
            this.brokerClient = new BrokerClient(this.getAgent1Hostname(), this.getAgent1Port(), this.getEncodingProtocolType());
            this.brokerClient.connect();
        }
        catch (Throwable e) {
            this.setReasonForFailure(e);
        }
    }

    @Override
    protected void build() throws Throwable {
        this.addAction();
        this.addConsequece();
    }

    protected void addConsequece() {
        FaultConsequence consequence = new FaultConsequence("fault receiver", "producer", this.faultFuture);
        consequence.setFaultCode(this.getFaultCode());
        consequence.setFaultMessage(this.getFaultMessage());
        this.addConsequences(consequence);
    }

    private void addAction() {
        this.setAction(new Action("message publisher", "producer"){

            @Override
            public Step run() throws Exception {
                try {
                    GenericNegativeTest.this.brokerClient = GenericNegativeTest.this.getBrokerClient();
                    GenericNegativeTest.this.brokerClient.setFaultListener(GenericNegativeTest.this.getErrorListener());
                    byte[] data = GenericNegativeTest.this.getDataToSend();
                    Byte[] byteObjects = new Byte[data.length];
                    int i = 0;
                    for (byte b : data) {
                        byteObjects[i++] = b;
                    }
                    ChannelFuture f = GenericNegativeTest.this.brokerClient.getHosts().getAvailableHost().getChannel().writeAndFlush((Object)byteObjects);
                    f.get();
                    this.setDone(true);
                    this.setSucess(true);
                }
                catch (Throwable t) {
                    this.setReasonForFailure(t.toString());
                }
                return this;
            }
        });
    }

    @Override
    protected void end() {
        try {
            this.brokerClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void setDataToSend(byte[] dataToSend) {
        this.dataToSend = dataToSend;
    }

    public byte[] getDataToSend() {
        return this.dataToSend;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultMessage(String faultMessage) {
        this.faultMessage = faultMessage;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public void setErrorListener(BrokerListener defaultErrorListener) {
        this.defaultErrorListener = defaultErrorListener;
    }

    public BrokerListener getErrorListener() {
        return this.defaultErrorListener;
    }

    public void setFaultActionId(String faultActionId) {
        this.faultActionId = faultActionId;
    }

    public String getFaultActionId() {
        return this.faultActionId;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setOkToTimeout(boolean okToTimeout) {
        this.okToTimeout = okToTimeout;
    }

    public boolean isOkToTimeout() {
        return this.okToTimeout;
    }
}

