/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.codec.thrift.ThriftBindingSerializer;
import pt.com.broker.codec.xml.SoapBindingSerializer;
import pt.com.broker.functests.helpers.GenericNegativeTest;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;

public class GenericNetMessageNegativeTest
extends GenericNegativeTest {
    private NetMessage message;

    public GenericNetMessageNegativeTest(NetProtocolType protocolType) {
        super(protocolType);
    }

    @Override
    protected void build() throws Throwable {
        this.setDataToSend(this.buildMessage());
        super.build();
    }

    private byte[] buildMessage() {
        SoapBindingSerializer encoder = null;
        switch (this.getEncodingProtocolType()) {
            case SOAP_v0: 
            case SOAP: {
                encoder = new SoapBindingSerializer();
                break;
            }
            case PROTOCOL_BUFFER: {
                encoder = new ProtoBufBindingSerializer();
                break;
            }
            case THRIFT: {
                encoder = new ThriftBindingSerializer();
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] headerWithoutSize = new byte[]{0, (byte)this.getEncodingProtocolType().ordinal(), 0, 0};
            byte[] rawData = encoder.marshal(this.getMessage());
            if (!this.getEncodingProtocolType().equals((Object)NetProtocolType.SOAP_v0)) {
                dataOutputStream.write(headerWithoutSize);
            }
            dataOutputStream.writeInt(rawData.length);
            dataOutputStream.write(rawData);
        }
        catch (IOException e) {
            System.err.println(e);
            this.setFailure(e);
        }
        catch (Exception ex) {
            System.err.println(ex);
            this.setFailure(ex);
        }
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return byteArray;
    }

    public void setMessage(NetMessage message) {
        this.message = message;
    }

    public NetMessage getMessage() {
        return this.message;
    }
}

