/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.AcceptRequest;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.AcceptResponseListener;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.exceptions.SubscriptionNotFound;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.Action;
import pt.com.broker.functests.Epilogue;
import pt.com.broker.functests.Prerequisite;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.helpers.BrokerTest;
import pt.com.broker.functests.helpers.NotificationConsequence;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetSubscribeAction;

public class GenericPubSubTest
extends BrokerTest {
    private static final Logger log = LoggerFactory.getLogger(GenericPubSubTest.class);
    private String destinationName = "/topic/foo";
    private String subscriptionName = "/topic/foo";
    private NetAction.DestinationType destinationType = NetAction.DestinationType.TOPIC;
    private NotificationListenerAdapter brokerListener;
    private BrokerClient infoConsumer;
    private BrokerClient infoProducer;
    protected boolean constructionFailed = false;
    protected Throwable reasonForFailure;
    NetNotification[] last = new NetNotification[]{null};

    public GenericPubSubTest(NetProtocolType protocolType) {
        super(protocolType);
        this.setName("GenericPubSubTest");
        try {
            String host = this.getAgent1Hostname();
            this.infoConsumer = new BrokerClient(host, this.getAgent1Port(), this.getEncodingProtocolType());
            this.infoConsumer.connect();
            this.infoProducer = new BrokerClient(host, this.getAgent1Port(), this.getEncodingProtocolType());
            this.infoProducer.connect();
        }
        catch (Throwable t) {
            this.constructionFailed = true;
            this.reasonForFailure = t;
            throw t;
        }
    }

    @Override
    protected void end() {
        try {
            this.infoConsumer.close();
            this.infoProducer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void build() throws Throwable {
        if (this.constructionFailed) {
            throw this.reasonForFailure;
        }
        if (this.getBrokerListener() == null) {
            this.brokerListener = new NotificationListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onMessage(NetNotification message, HostInfo host) {
                    NetNotification[] netNotificationArray = GenericPubSubTest.this.last;
                    synchronized (GenericPubSubTest.this.last) {
                        GenericPubSubTest.this.last[0] = message;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }
            };
        }
        this.addPrerequisites();
        this.addAction();
        this.addConsequences();
        this.addEpilogues();
    }

    @Override
    public void setFailure(Throwable throwable) {
        this.constructionFailed = true;
        this.reasonForFailure = throwable;
    }

    protected void addPrerequisites() {
        this.addPrerequisite(new Prerequisite("Subscription"){

            @Override
            public Step run() throws Exception {
                try {
                    NetSubscribe subscribe = new NetSubscribe(GenericPubSubTest.this.getSubscriptionName(), GenericPubSubTest.this.getDestinationType());
                    AtomicBoolean success = new AtomicBoolean(false);
                    final ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
                    AcceptRequest request = new AcceptRequest(UUID.randomUUID().toString(), new AcceptResponseListener(){

                        public void onMessage(NetAccepted message, HostInfo host) {
                            log.info("Success");
                            queue.add(true);
                        }

                        public void onFault(NetFault fault, HostInfo host) {
                            log.error("Fault");
                            queue.add(false);
                        }

                        public void onTimeout(String actionID) {
                            log.error("Timeout");
                            queue.add(false);
                        }
                    }, 10000L);
                    GenericPubSubTest.this.getInfoConsumer().subscribe((NetSubscribeAction)subscribe, (BrokerListener)GenericPubSubTest.this.getBrokerListener(), request);
                    this.setDone(true);
                    this.setSucess((Boolean)queue.take());
                }
                catch (Throwable t) {
                    throw new Exception(t);
                }
                return this;
            }
        });
    }

    protected void addAction() {
        this.setAction(new Action("Publish", "producer"){

            @Override
            public Step run() throws Exception {
                try {
                    NetBrokerMessage brokerMessage = new NetBrokerMessage(GenericPubSubTest.this.getData());
                    Future f = GenericPubSubTest.this.getInfoProducer().publish(brokerMessage, GenericPubSubTest.this.getDestinationName(), GenericPubSubTest.this.getDestinationType());
                    f.get();
                    Thread.sleep(2000L);
                    this.setDone(true);
                    this.setSucess(true);
                }
                catch (Throwable t) {
                    throw new Exception(t);
                }
                return this;
            }
        });
    }

    protected void addConsequences() {
        NotificationConsequence notConsequence = new NotificationConsequence("Consume", "consumer", this.last);
        notConsequence.setDestination(this.getDestinationName());
        notConsequence.setSubscription(this.getSubscriptionName());
        notConsequence.setDestinationType(this.getDestinationType());
        notConsequence.setMessagePayload(this.getData());
        this.addConsequences(notConsequence);
    }

    protected void addEpilogues() {
        this.addEpilogue(new Epilogue("Epilogue"){

            @Override
            public Step run() throws Exception {
                block6: {
                    try {
                        GenericPubSubTest.this.getInfoConsumer().unsubscribe(GenericPubSubTest.this.getDestinationType(), GenericPubSubTest.this.getSubscriptionName());
                    }
                    catch (Throwable t) {
                        if (t.getCause() instanceof SubscriptionNotFound) {
                            break block6;
                        }
                        throw new Exception(t);
                    }
                    finally {
                        this.setDone(true);
                        this.setSucess(true);
                        GenericPubSubTest.this.getInfoConsumer().close();
                    }
                }
                return this;
            }
        });
    }

    public void setDestinationName(String topicName) {
        this.destinationName = topicName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setBrokerListener(NotificationListenerAdapter brokerListener) {
        this.brokerListener = brokerListener;
    }

    public NotificationListenerAdapter getBrokerListener() {
        return this.brokerListener;
    }

    public void setInfoConsumer(BrokerClient infoConsumer) {
        this.infoConsumer = infoConsumer;
    }

    public BrokerClient getInfoConsumer() {
        return this.infoConsumer;
    }

    public void setInfoProducer(BrokerClient infoProducer) {
        this.infoProducer = infoProducer;
    }

    public BrokerClient getInfoProducer() {
        return this.infoProducer;
    }

    public void setDestinationType(NetAction.DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }
}

