/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.caudexorigo.text.RandomStringUtils;
import pt.com.broker.client.nio.AcceptRequest;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.AcceptResponseListener;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.exceptions.SubscriptionNotFound;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.Action;
import pt.com.broker.functests.Epilogue;
import pt.com.broker.functests.Prerequisite;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.helpers.BrokerTest;
import pt.com.broker.functests.helpers.MultipleNotificationConsequence;
import pt.com.broker.functests.helpers.MultipleNotificationsBrokerListener;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetSubscribeAction;

public class MultipleGenericPubSubTest
extends BrokerTest {
    private String baseName = RandomStringUtils.randomAlphanumeric((int)10);
    private String destinationName = String.format("/%s/foo", this.getBaseName());
    private String subscriptionName = String.format("/%s/foo", this.getBaseName());
    private NetAction.DestinationType destinationType;
    private NetAction.DestinationType consumerDestinationType = this.destinationType = NetAction.DestinationType.TOPIC;
    private List<TestClientInfo> infoConsumers;
    private List<TestClientInfo> infoProducers;

    public MultipleGenericPubSubTest(NetProtocolType protocolType) {
        super(protocolType);
        this.setName("MultipleGenericPubSubTest");
        this.infoConsumers = new ArrayList<TestClientInfo>();
        this.infoProducers = new ArrayList<TestClientInfo>();
    }

    @Override
    public void build() throws Throwable {
        this.addProducers();
        this.addConsumers();
        if (this.isConstructionFailed()) {
            throw this.getReasonForFailure();
        }
        this.addPrerequisites();
        this.addAction();
        this.addConsequences();
        this.addEpilogues();
    }

    @Override
    protected void end() {
        try {
            for (TestClientInfo info : this.infoConsumers) {
                if (info == null || info.brokerClient == null) continue;
                info.brokerClient.close();
            }
            for (TestClientInfo info : this.infoProducers) {
                if (info == null || info.brokerClient == null) continue;
                info.brokerClient.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addConsumers() {
        try {
            int numberOfExecutions = this.getInfoProducers().size();
            TestClientInfo tci = new TestClientInfo();
            tci.brokerClient = new BrokerClient(this.getAgent1Hostname(), this.getAgent1Port(), this.getEncodingProtocolType());
            tci.brokerClient.connect();
            tci.brokerListenter = new MultipleNotificationsBrokerListener(this.getDestinationType(), numberOfExecutions);
            tci.numberOfExecutions = numberOfExecutions;
            this.addInfoConsumer(tci);
        }
        catch (Throwable t) {
            this.setFailure(t);
        }
    }

    protected void addProducers() {
        try {
            TestClientInfo tci = new TestClientInfo();
            int port = this.getAgent1Port();
            tci.brokerClient = new BrokerClient(this.getAgent1Hostname(), port, this.getEncodingProtocolType());
            tci.brokerClient.connect();
            tci.brokerListenter = null;
            tci.numberOfExecutions = 1;
            this.addInfoProducer(tci);
        }
        catch (Throwable t) {
            this.setFailure(t);
        }
    }

    protected void addPrerequisites() {
        this.addPrerequisite(new Prerequisite("Subscription"){

            @Override
            public Step run() throws Exception {
                NetSubscribe subscribe = new NetSubscribe(MultipleGenericPubSubTest.this.getSubscriptionName(), MultipleGenericPubSubTest.this.getConsumerDestinationType());
                for (TestClientInfo tci : MultipleGenericPubSubTest.this.getInfoConsumers()) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    tci.brokerClient.subscribe((NetSubscribeAction)subscribe, (BrokerListener)tci.brokerListenter, new AcceptRequest(UUID.randomUUID().toString(), new AcceptResponseListener(){

                        public void onMessage(NetAccepted message, HostInfo host) {
                            latch.countDown();
                        }

                        public void onFault(NetFault fault, HostInfo host) {
                            latch.countDown();
                        }

                        public void onTimeout(String actionID) {
                            latch.countDown();
                        }
                    }, 6000L)).get();
                    latch.await();
                }
                this.setDone(true);
                this.setSucess(true);
                return this;
            }
        });
    }

    protected void addAction() {
        this.setAction(new Action("Publish", "producer"){

            @Override
            public Step run() throws Exception {
                for (TestClientInfo tci : MultipleGenericPubSubTest.this.getInfoProducers()) {
                    NetBrokerMessage brokerMessage = new NetBrokerMessage(MultipleGenericPubSubTest.this.getData());
                    final CountDownLatch latch = new CountDownLatch(1);
                    tci.brokerClient.publish(brokerMessage, MultipleGenericPubSubTest.this.getDestinationName(), MultipleGenericPubSubTest.this.getDestinationType(), new AcceptRequest(UUID.randomUUID().toString(), new AcceptResponseListener(){

                        public void onMessage(NetAccepted message, HostInfo host) {
                            latch.countDown();
                        }

                        public void onFault(NetFault fault, HostInfo host) {
                            latch.countDown();
                        }

                        public void onTimeout(String actionID) {
                            latch.countDown();
                        }
                    }, 6000L)).get();
                    latch.await();
                }
                this.setDone(true);
                this.setSucess(true);
                return this;
            }
        });
    }

    protected void addConsequences() {
        for (TestClientInfo tci : this.getInfoConsumers()) {
            MultipleNotificationConsequence notConsequence = new MultipleNotificationConsequence("Consume", "consumer", tci.brokerListenter);
            notConsequence.setDestination(this.getDestinationName());
            notConsequence.setSubscription(this.getSubscriptionName());
            NetAction.DestinationType dt = this.getConsumerDestinationType().equals((Object)NetAction.DestinationType.VIRTUAL_QUEUE) ? NetAction.DestinationType.QUEUE : this.getConsumerDestinationType();
            notConsequence.setDestinationType(dt);
            notConsequence.setMessagePayload(this.getData());
            this.addConsequences(notConsequence);
        }
    }

    protected void addEpilogues() {
        this.addEpilogue(new Epilogue("Epilogue"){

            @Override
            public Step run() throws Exception {
                block3: {
                    try {
                        for (TestClientInfo tci : MultipleGenericPubSubTest.this.getInfoConsumers()) {
                            tci.brokerClient.unsubscribe(MultipleGenericPubSubTest.this.getDestinationType(), MultipleGenericPubSubTest.this.getSubscriptionName()).get();
                        }
                        this.setDone(true);
                        this.setSucess(true);
                    }
                    catch (Throwable t) {
                        if (t.getCause() instanceof SubscriptionNotFound) break block3;
                        throw t;
                    }
                }
                return this;
            }
        });
    }

    public void setDestinationName(String topicName) {
        this.destinationName = topicName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void addInfoConsumer(TestClientInfo infoConsumer) {
        this.infoConsumers.add(infoConsumer);
    }

    public List<TestClientInfo> getInfoConsumers() {
        return this.infoConsumers;
    }

    public void addInfoProducer(TestClientInfo infoProducer) {
        this.infoProducers.add(infoProducer);
    }

    public List<TestClientInfo> getInfoProducers() {
        return this.infoProducers;
    }

    public void setDestinationType(NetAction.DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setConsumerDestinationType(NetAction.DestinationType consumerDestinationType) {
        this.consumerDestinationType = consumerDestinationType;
    }

    public NetAction.DestinationType getConsumerDestinationType() {
        return this.consumerDestinationType;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public static class TestClientInfo {
        public BrokerClient brokerClient;
        public MultipleNotificationsBrokerListener brokerListenter;
        public int numberOfExecutions;
    }
}

