/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.functests.Consequence;
import pt.com.broker.functests.Step;
import pt.com.broker.functests.helpers.MultipleNotificationsBrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetNotification;

public class MultipleNotificationConsequence
extends Consequence {
    private static final Logger log = LoggerFactory.getLogger(MultipleNotificationConsequence.class);
    private MultipleNotificationsBrokerListener brokerListener;
    private String destination;
    private String subscription;
    private NetAction.DestinationType destinationType;
    private byte[] messagePayload;

    public MultipleNotificationConsequence(String name, String actorName, MultipleNotificationsBrokerListener brokerListener) {
        super(name, actorName);
        this.brokerListener = brokerListener;
    }

    @Override
    public Step run() throws Exception {
        log.info("Start - Waiting for List NetNotification");
        List<NetNotification> notifications = this.brokerListener.getFuture().get();
        log.info("Done - Waiting for List NetNotification");
        for (NetNotification netNotification : notifications) {
            String reason;
            if (this.destinationType != null) {
                if (!netNotification.getDestinationType().toString().equals(this.destinationType.toString())) {
                    reason = String.format("Destination type mismatch! Expected: %s Received: %s", this.destinationType, netNotification.getDestinationType());
                    this.setReasonForFailure(reason);
                    return this;
                }
            } else {
                this.setReasonForFailure("destinationType field is null.");
            }
            if (this.destination != null) {
                if (this.subscription.contains("@")) {
                    if (!netNotification.getDestination().equals(this.subscription)) {
                        reason = String.format("Destination mismatch! Expected: %s Received: %s (because it's a virtual queue)", this.subscription, netNotification.getDestination());
                        this.setReasonForFailure(reason);
                        return this;
                    }
                } else if (!netNotification.getDestination().equals(this.destination)) {
                    reason = String.format("Destination mismatch! Expected: %s Received: %s", this.destination, netNotification.getDestination());
                    this.setReasonForFailure(reason);
                    return this;
                }
            } else {
                this.setReasonForFailure("destination field is null.");
            }
            if (this.subscription != null) {
                if (!netNotification.getSubscription().equals(this.subscription)) {
                    reason = String.format("Subscription mismatch! Expected: %s Received: %s", this.subscription, netNotification.getSubscription());
                    this.setReasonForFailure(reason);
                    return this;
                }
            } else {
                this.setReasonForFailure("subscription field is null.");
            }
            if (this.messagePayload != null) {
                NetBrokerMessage message = netNotification.getMessage();
                if (Arrays.equals(message.getPayload(), this.messagePayload)) continue;
                this.setReasonForFailure("Binary content mismatch!");
                return this;
            }
            this.setReasonForFailure("messagePayload field is null.");
        }
        this.setDone(true);
        this.setSucess(true);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setDestinationType(NetAction.DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setMessagePayload(byte[] messagePayload) {
        this.messagePayload = messagePayload;
    }

    public byte[] getMessagePayload() {
        return this.messagePayload;
    }
}

