/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.helpers;

import java.util.Arrays;
import pt.com.broker.functests.Consequence;
import pt.com.broker.functests.Step;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetNotification;

public class NotificationConsequence
extends Consequence {
    private NetNotification[] notifications;
    private String destination;
    private String subscription;
    private NetAction.DestinationType destinationType;
    private byte[] messagePayload;

    public NotificationConsequence(String name, String actorName, NetNotification[] netNotification) {
        super(name, actorName);
        this.notifications = netNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Step run() throws Exception {
        Thread.sleep(1000L);
        NetNotification netNotification = null;
        NetNotification[] netNotificationArray = this.notifications;
        synchronized (this.notifications) {
            NetBrokerMessage message;
            String reason;
            netNotification = this.notifications[0];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (netNotification == null) {
                this.setDone(true);
                this.setSucess(false);
                return this;
            }
            if (this.destinationType != null && !netNotification.getDestinationType().toString().equals(this.destinationType.toString())) {
                reason = String.format("Destination type mismatch! Expected: %s Received: %s", this.destinationType, netNotification.getDestinationType());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.destination != null && !netNotification.getDestination().equals(this.destination)) {
                reason = String.format("Destination mismatch! Expected: %s Received: %s", this.destination, netNotification.getDestination());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.subscription != null && !netNotification.getSubscription().equals(this.subscription)) {
                reason = String.format("Subscription mismatch! Expected: %s Received: %s", this.subscription, netNotification.getSubscription());
                this.setReasonForFailure(reason);
                return this;
            }
            if (this.messagePayload != null && !Arrays.equals((message = netNotification.getMessage()).getPayload(), this.messagePayload)) {
                this.setReasonForFailure("Binary content mismatch!");
                return this;
            }
            this.setDone(true);
            this.setSucess(true);
            return this;
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setDestinationType(NetAction.DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setMessagePayload(byte[] messagePayload) {
        this.messagePayload = messagePayload;
    }

    public byte[] getMessagePayload() {
        return this.messagePayload;
    }
}

