/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.samples;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.cli.CliFactory;
import pt.com.broker.auth.CredentialsProvider;
import pt.com.broker.auth.saposts.SapoSTSProvider;
import pt.com.broker.client.nio.SslBrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.samples.CliArgs;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetSubscribeAction;

public class AuthenticatedConsumer
extends NotificationListenerAdapter {
    private final AtomicInteger counter = new AtomicInteger(0);
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;
    private String stsLocation;
    private String stsUsername;
    private String stsPassword;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        AuthenticatedConsumer consumer = new AuthenticatedConsumer();
        consumer.host = cargs.getHost();
        consumer.port = cargs.getPort();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        consumer.stsLocation = cargs.getSTSLocation();
        consumer.stsUsername = cargs.getUsername();
        consumer.stsPassword = cargs.getUserPassword();
        SslBrokerClient bk = new SslBrokerClient(NetProtocolType.PROTOCOL_BUFFER);
        bk.addServer(consumer.host, consumer.port);
        SapoSTSProvider cp = StringUtils.isBlank((CharSequence)consumer.stsLocation) ? new SapoSTSProvider(consumer.stsUsername, consumer.stsPassword) : new SapoSTSProvider(consumer.stsUsername, consumer.stsPassword, consumer.stsLocation);
        bk.setCredentialsProvider((CredentialsProvider)cp);
        try {
            if (!bk.authenticateClient()) {
                System.out.println("Authentication failed");
                return;
            }
        }
        catch (Throwable t) {
            System.out.println("Unable to authenticate client...");
            System.out.println(t);
            return;
        }
        System.out.println("subscribing");
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        bk.subscribe((NetSubscribeAction)subscribe, (BrokerListener)consumer);
        System.out.println("listening...");
    }

    public boolean onMessage(NetNotification notification, HostInfo host) {
        System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), this.counter.incrementAndGet());
        System.out.printf("Destination: '%s'%n", notification.getDestination());
        System.out.printf("Subscription: '%s'%n", notification.getSubscription());
        System.out.printf("Payload: '%s'%n", new String(notification.getMessage().getPayload()));
        return this.dtype != NetAction.DestinationType.TOPIC;
    }
}

