/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.simulation;

import org.caudexorigo.Shutdown;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.simulation.MainAll;
import pt.com.broker.functests.simulation.TestMachines;
import pt.com.broker.functests.simulation.helpers.Consumers;
import pt.com.broker.functests.simulation.helpers.Producers;
import pt.com.broker.functests.simulation.helpers.SyncConsumers;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;

public class ScenarioB {
    public static void run() {
        ScenarioB.run(TestMachines.All);
    }

    public static void run(TestMachines testMachines) {
        String bTopic = "/topic/bbb";
        if (testMachines == TestMachines.Machine1 || testMachines == TestMachines.All) {
            SyncConsumers bbbSC1 = new SyncConsumers(30, String.format("sb1@%s", "/topic/bbb"), 2000L, 0L, new HostInfo(MainAll.Agent1Hostname, MainAll.Agent1Port), NetProtocolType.PROTOCOL_BUFFER, "S B - SC1 ");
            bbbSC1.init();
            bbbSC1.start();
        }
        if (testMachines == TestMachines.Machine2 || testMachines == TestMachines.All) {
            SyncConsumers bbbSC2 = new SyncConsumers(30, String.format("sb1@%s", "/topic/bbb"), 2000L, 0L, new HostInfo(MainAll.Agent2Hostname, MainAll.Agent2Port), NetProtocolType.PROTOCOL_BUFFER, "S B - SC2 ");
            bbbSC2.init();
            bbbSC2.start();
        }
        if (testMachines == TestMachines.Machine1 || testMachines == TestMachines.All) {
            Consumers bbbVQC1 = new Consumers(NetAction.DestinationType.VIRTUAL_QUEUE, 1, String.format("sb2@%s", "/topic/bbb"), 50L, 0L, 0L, new HostInfo(MainAll.Agent1Hostname, MainAll.Agent1Port), NetProtocolType.PROTOCOL_BUFFER, "S B - VQ1 ");
            bbbVQC1.init();
            bbbVQC1.start();
        }
        if (testMachines == TestMachines.Machine2 || testMachines == TestMachines.All) {
            Consumers bbbVQC2 = new Consumers(NetAction.DestinationType.VIRTUAL_QUEUE, 1, String.format("sb2@%s", "/topic/bbb"), 50L, 0L, 0L, new HostInfo(MainAll.Agent2Hostname, MainAll.Agent2Port), NetProtocolType.PROTOCOL_BUFFER, "S B - VQ2 ");
            bbbVQC2.init();
            bbbVQC2.start();
        }
        if (testMachines == TestMachines.Machine1 || testMachines == TestMachines.All) {
            Producers bbbP1 = new Producers(1, "/topic/bbb", NetAction.DestinationType.TOPIC, 0, 100, new HostInfo(MainAll.Agent1Hostname, MainAll.Agent1Port), NetProtocolType.PROTOCOL_BUFFER, "S B - p1 ");
            bbbP1.init();
            bbbP1.start();
        }
        if (testMachines == TestMachines.Machine2 || testMachines == TestMachines.All) {
            Producers bbbP2 = new Producers(1, "/topic/bbb", NetAction.DestinationType.TOPIC, 0, 100, new HostInfo(MainAll.Agent2Hostname, MainAll.Agent2Port), NetProtocolType.PROTOCOL_BUFFER, "S B - p2 ");
            bbbP2.init();
            bbbP2.start();
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting Scenario B");
        TestMachines machines = TestMachines.All;
        if (args.length == 1) {
            if (args[0].equals("machine1")) {
                machines = TestMachines.Machine1;
                System.out.println("Working on machine1");
            } else if (args[0].equals("machine2")) {
                machines = TestMachines.Machine2;
                System.out.println("Working on machine2");
            } else {
                System.out.println(String.format("Expecting %s [ machine1 | machine2 ] ", "ScenarioB"));
                Shutdown.now();
            }
        }
        ScenarioB.run(machines);
    }
}

