/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.simulation;

import org.caudexorigo.Shutdown;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.functests.simulation.MainAll;
import pt.com.broker.functests.simulation.TestMachines;
import pt.com.broker.functests.simulation.helpers.Consumers;
import pt.com.broker.functests.simulation.helpers.Producers;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;

public class ScenarioC {
    public static void run() {
        ScenarioC.run(TestMachines.All);
    }

    public static void run(TestMachines testMachines) {
        String cTopic = "/topic/ccc";
        if (testMachines == TestMachines.Machine1 || testMachines == TestMachines.All) {
            Producers cccP1 = new Producers(1, "/topic/ccc", NetAction.DestinationType.TOPIC, 50, 0, new HostInfo(MainAll.Agent1Hostname, MainAll.Agent1Port), NetProtocolType.PROTOCOL_BUFFER, "S C - p1 ");
            cccP1.init();
            cccP1.start();
        }
        if (testMachines == TestMachines.Machine2 || testMachines == TestMachines.All) {
            Producers cccP2 = new Producers(2, "/topic/ccc", NetAction.DestinationType.TOPIC, 50, 0, new HostInfo(MainAll.Agent2Hostname, MainAll.Agent2Port), NetProtocolType.PROTOCOL_BUFFER, "S C - p2 ");
            cccP2.init();
            cccP2.start();
        }
        if (testMachines == TestMachines.Machine1 || testMachines == TestMachines.All) {
            Consumers cccVQC1 = new Consumers(NetAction.DestinationType.TOPIC, 1, String.format("%s", "/topic/ccc"), 0L, 0L, 0L, new HostInfo(MainAll.Agent1Hostname, MainAll.Agent1Port), NetProtocolType.PROTOCOL_BUFFER, "S C - c1 ");
            cccVQC1.init();
            cccVQC1.start();
        }
        if (testMachines == TestMachines.Machine2 || testMachines == TestMachines.All) {
            Consumers cccVQC2 = new Consumers(NetAction.DestinationType.TOPIC, 1, String.format("%s", "/topic/ccc"), 0L, 0L, 0L, new HostInfo(MainAll.Agent2Hostname, MainAll.Agent2Port), NetProtocolType.PROTOCOL_BUFFER, "S C - c2 ");
            cccVQC2.init();
            cccVQC2.start();
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting Scenario C");
        TestMachines machines = TestMachines.All;
        if (args.length == 1) {
            if (args[0].equals("machine1")) {
                machines = TestMachines.Machine1;
                System.out.println("Working on machine1");
            } else if (args[0].equals("machine2")) {
                machines = TestMachines.Machine2;
                System.out.println("Working on machine2");
            } else {
                System.out.println(String.format("Expecting %s [ machine1 | machine2 ] ", "ScenarioC"));
                Shutdown.now();
            }
        }
        ScenarioC.run(machines);
    }
}

