/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.functests.simulation.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.caudexorigo.concurrent.Sleep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetSubscribeAction;
import pt.com.gcs.messaging.GcsExecutor;

public class Consumers {
    private static final Logger log = LoggerFactory.getLogger(Consumers.class);
    private final int counsumersCount;
    private final long ackDelay;
    private final HostInfo hostInfo;
    private final long subscriptionDuration;
    private final long unsubscribedDuration;
    private final NetProtocolType protocolType;
    private final String appName;
    private List<ConsumerInfo> consumers;
    private final String destinationName;
    private NetSubscribe subscribeMsg;
    private final NetAction.DestinationType destinationType;
    private static List<Consumers> activeConsumers = new ArrayList<Consumers>();

    public Consumers(NetAction.DestinationType destinationType, int counsumersCount, String destinationName, long ackDelay, long subscriptionDuration, long unsubscribedDuration, HostInfo hostInfo, NetProtocolType protocolType, String appName) {
        this.destinationType = destinationType;
        this.counsumersCount = counsumersCount;
        this.destinationName = destinationName;
        this.ackDelay = ackDelay;
        this.subscriptionDuration = subscriptionDuration;
        this.unsubscribedDuration = unsubscribedDuration;
        this.hostInfo = hostInfo;
        this.protocolType = protocolType;
        this.appName = appName;
    }

    public void init() {
        this.consumers = new ArrayList<ConsumerInfo>(this.counsumersCount);
        for (int i = 0; i != this.counsumersCount; ++i) {
            ConsumerInfo ci = new ConsumerInfo();
            try {
                ci.consumerName = this.appName + i;
                ci.brokerClient = new BrokerClient(this.hostInfo.getHostname(), this.hostInfo.getPort(), this.protocolType);
                this.consumers.add(ci);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        this.subscribeMsg = new NetSubscribe(this.destinationName, this.destinationType);
        Random random = new Random(System.currentTimeMillis());
        Iterator<ConsumerInfo> iterator = this.consumers.iterator();
        while (iterator.hasNext()) {
            ConsumerInfo ci;
            final ConsumerInfo consumerInfo = ci = iterator.next();
            NotificationListenerAdapter listener = new NotificationListenerAdapter(){

                public boolean onMessage(NetNotification message, HostInfo host) {
                    ++consumerInfo.messagesReceived;
                    if (Consumers.this.ackDelay != 0L) {
                        Sleep.time((long)Consumers.this.ackDelay);
                    }
                    try {
                        if (Consumers.this.destinationType != NetAction.DestinationType.TOPIC) {
                            consumerInfo.brokerClient.acknowledge(message);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return false;
                }
            };
            try {
                ci.brokerClient.subscribe((NetSubscribeAction)this.subscribeMsg, (BrokerListener)listener);
                ci.listener = listener;
                if (this.subscriptionDuration == 0L || this.unsubscribedDuration == 0L) continue;
                ci.nextAction = ConsumerInfo.SubscriptionAction.Unsubscribe;
                ci.actionTime = System.currentTimeMillis() + random.nextLong() % this.subscriptionDuration;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.subscriptionDuration != 0L && this.unsubscribedDuration != 0L) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    for (ConsumerInfo ci : Consumers.this.consumers) {
                        if (ci.actionTime >= now) continue;
                        if (ci.nextAction == ConsumerInfo.SubscriptionAction.Subscribe) {
                            try {
                                ci.brokerClient.subscribe((NetSubscribeAction)Consumers.this.subscribeMsg, ci.listener);
                                ci.nextAction = ConsumerInfo.SubscriptionAction.Unsubscribe;
                                ci.actionTime = now + Consumers.this.subscriptionDuration;
                            }
                            catch (Throwable e) {
                                log.error("Failed to subscribe", e);
                            }
                            continue;
                        }
                        try {
                            ci.brokerClient.unsubscribe(NetAction.DestinationType.VIRTUAL_QUEUE, Consumers.this.destinationName);
                            ci.nextAction = ConsumerInfo.SubscriptionAction.Subscribe;
                            ci.actionTime = now + Consumers.this.unsubscribedDuration;
                        }
                        catch (Throwable e) {
                            log.error("Failed to unsubscribe", e);
                        }
                    }
                }
            };
            GcsExecutor.scheduleAtFixedRate((Runnable)command, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        activeConsumers.add(this);
    }

    public void end() {
        for (ConsumerInfo ci : this.consumers) {
            try {
                ci.brokerClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.consumers.clear();
        activeConsumers.remove(this);
    }

    static {
        long interval = 15L;
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                for (Consumers consumers : activeConsumers) {
                    sb.append("\nConsumers:");
                    sb.append(consumers.appName);
                    sb.append("\n");
                    for (ConsumerInfo ci : consumers.consumers) {
                        sb.append(String.format("Messages received in the last %s (s) by %s: %s\n", 15L, ci.consumerName, ci.messagesReceived));
                        ci.messagesReceived = 0L;
                    }
                }
                System.out.println(sb.toString());
            }
        };
        GcsExecutor.scheduleAtFixedRate((Runnable)command, (long)15L, (long)15L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static class ConsumerInfo {
        public BrokerClient brokerClient;
        public SubscriptionAction nextAction;
        public long actionTime = Long.MAX_VALUE;
        public String consumerName;
        public volatile long messagesReceived = 0L;
        public BrokerListener listener;

        private ConsumerInfo() {
        }

        public static enum SubscriptionAction {
            Subscribe,
            Unsubscribe;

        }
    }
}

