/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.ReferenceCountUtil;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.caudexorigo.concurrent.CustomExecutors;
import org.caudexorigo.http.netty4.CacheKey;
import org.caudexorigo.http.netty4.CacheKeyBuilder;
import org.caudexorigo.http.netty4.HttpAction;
import org.caudexorigo.http.netty4.RequestObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAdapter
extends HttpAction {
    private static Logger log = LoggerFactory.getLogger(HttpAction.class);
    private static final ScheduledExecutorService schedExec = CustomExecutors.newScheduledThreadPool((int)2, (String)"sched-exec");
    private static final CharSequence ncache = HttpHeaders.newEntity((String)"X-NCache");
    private static final CharSequence hit = HttpHeaders.newEntity((String)"hit");
    private static final CharSequence lookup = HttpHeaders.newEntity((String)"lookup");
    private static final CharSequence pass_through = HttpHeaders.newEntity((String)"pass-through");
    private HttpAction wrapped;
    private final ConcurrentMap<CacheKey, FullHttpResponse> cachedContent = new ConcurrentHashMap<CacheKey, FullHttpResponse>();
    private CacheKeyBuilder cacheKeyBuilder;

    public CacheAdapter(HttpAction wrapped, CacheKeyBuilder cacheKeyBuilder) {
        this.wrapped = wrapped;
        this.cacheKeyBuilder = cacheKeyBuilder;
    }

    @Override
    public void service(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse rsp) {
    }

    @Override
    protected void process(ChannelHandlerContext ctx, FullHttpRequest request, RequestObserver requestObserver) {
        if (request.getMethod().equals((Object)HttpMethod.GET)) {
            this.observeBegin(ctx, (HttpRequest)request, requestObserver);
            FullHttpResponse response = this.cachedProcess(ctx, request, requestObserver);
            boolean is_keep_alive = HttpHeaders.isKeepAlive((HttpMessage)request);
            this.commitResponse(ctx, response, is_keep_alive);
            this.observeEnd(ctx, (HttpRequest)request, (HttpResponse)response, requestObserver);
        } else {
            this.wrapped.process(ctx, request, requestObserver);
        }
    }

    private FullHttpResponse cachedProcess(ChannelHandlerContext ctx, FullHttpRequest request, RequestObserver requestObserver) {
        this.prepareRequest(request);
        final CacheKey ck = this.cacheKeyBuilder.build(ctx, request);
        FullHttpResponse response = (FullHttpResponse)this.cachedContent.get(ck);
        if (response == null) {
            response = this.buildResponse(ctx);
            log.debug("Cache miss for: {}", (Object)ck);
            ReferenceCountUtil.retain((Object)response);
            try {
                this.wrapped.service(ctx, request, response);
            }
            catch (Throwable t) {
                if (response != null) {
                    ReferenceCountUtil.release((Object)response);
                }
                throw new RuntimeException(t);
            }
            this.prepareResponse(request, response);
            if (!this.isCacheable(response)) {
                log.warn("Response object for resource '{}' is not cacheable.", (Object)request.getUri());
                response.headers().set(ncache, (Object)pass_through);
                ReferenceCountUtil.release((Object)response);
                return response;
            }
            response.headers().set(ncache, (Object)lookup);
            this.cachedContent.put(ck, response);
            Runnable evictioner = new Runnable(){

                @Override
                public void run() {
                    CacheAdapter.this.evict(ck);
                }
            };
            schedExec.schedule(evictioner, ck.getCacheTime(), ck.getCacheTimeUnit());
        } else {
            if (response.content().readableBytes() == 0) {
                log.warn("Empty cache hit for: {}", (Object)ck, (Object)response.content());
                this.evict(ck);
                return this.cachedProcess(ctx, request, requestObserver);
            }
            log.debug("Cache hit for: {}", (Object)ck);
            response.headers().set(ncache, (Object)hit);
            ReferenceCountUtil.retain((Object)response);
        }
        return response;
    }

    private boolean isCacheable(FullHttpResponse response) {
        if (response.content().readableBytes() == 0) {
            log.warn("netty bug 'response.content().readableBytes() == 0', pass-through");
            return false;
        }
        return !response.headers().contains("Set-Cookie");
    }

    public void prepareRequest(FullHttpRequest request) {
    }

    public void prepareResponse(FullHttpRequest request, FullHttpResponse response) {
    }

    private FullHttpResponse evict(CacheKey ck) {
        log.debug("Evict entry '{}'", (Object)ck);
        FullHttpResponse rsp = (FullHttpResponse)this.cachedContent.remove(ck);
        if (rsp != null) {
            ReferenceCountUtil.release((Object)rsp);
        }
        return rsp;
    }

    public FullHttpResponse removeCachedEntry(CacheKey ck) {
        return this.evict(ck);
    }

    public void clear() {
        HashSet keys = new HashSet();
        keys.addAll(this.cachedContent.keySet());
        for (CacheKey ck : keys) {
            try {
                this.evict(ck);
            }
            catch (Throwable t) {
                log.warn("Error on eviction: {}", (Object)t.getMessage());
            }
        }
        this.cachedContent.clear();
        keys.clear();
    }
}

