/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.io.FileNotFoundException;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.http.netty4.DefaultObserver;
import org.caudexorigo.http.netty4.ErrorAction;
import org.caudexorigo.http.netty4.HttpAction;
import org.caudexorigo.http.netty4.RequestObserver;
import org.caudexorigo.http.netty4.RequestRouter;
import org.caudexorigo.http.netty4.WebException;
import org.caudexorigo.http.netty4.reporting.ResponseFormatter;
import org.caudexorigo.http.netty4.reporting.StandardResponseFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProtocolHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(HttpProtocolHandler.class);
    private final ResponseFormatter _rspFmt;
    private final RequestRouter _requestMapper;
    private final RequestObserver _requestObserver;

    public HttpProtocolHandler(RequestRouter requestMapper) {
        this._requestMapper = requestMapper;
        this._rspFmt = new StandardResponseFormatter(false);
        this._requestObserver = new DefaultObserver();
    }

    public HttpProtocolHandler(RequestRouter requestMapper, RequestObserver customObserver, ResponseFormatter customResponseFormtter) {
        this._requestMapper = requestMapper;
        this._rspFmt = customResponseFormtter == null ? new StandardResponseFormatter(false) : customResponseFormtter;
        this._requestObserver = customObserver == null ? new DefaultObserver() : customObserver;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (log.isDebugEnabled()) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)cause);
            log.debug(r.getMessage(), r);
        }
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            this.handleRead(ctx, request);
            try {
                ReferenceCountUtil.release((Object)request);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        } else {
            throw new IllegalArgumentException("Can only handle instances of FullHttpRequest messages");
        }
    }

    public void handleRead(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        try {
            HttpAction action = this._requestMapper.map(ctx, request);
            if (action == null) {
                throw new WebException(new FileNotFoundException("No available HttpAction for the request"), HttpResponseStatus.NOT_FOUND.code());
            }
            action.process(ctx, request, this._requestObserver);
        }
        catch (Throwable t) {
            ErrorAction errorAction;
            ByteBuf ebuf = ctx.alloc().buffer();
            DefaultFullHttpResponse eresponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, ebuf);
            Throwable w = this.findWebException(t);
            if (w instanceof WebException) {
                WebException we = (WebException)w;
                errorAction = new ErrorAction(we, this._rspFmt);
                eresponse.setStatus(HttpResponseStatus.valueOf((int)we.getHttpStatusCode()));
            } else if (w instanceof IllegalArgumentException) {
                WebException we = new WebException(w, HttpResponseStatus.BAD_REQUEST.code());
                errorAction = new ErrorAction(we, this._rspFmt);
                eresponse.setStatus(HttpResponseStatus.valueOf((int)we.getHttpStatusCode()));
            } else {
                Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
                errorAction = new ErrorAction(new WebException(r, HttpResponseStatus.INTERNAL_SERVER_ERROR.code()), this._rspFmt);
            }
            errorAction.doProcess(ctx, request, (FullHttpResponse)eresponse);
            errorAction.observeEnd(ctx, (HttpRequest)request, (HttpResponse)eresponse, this._requestObserver);
        }
    }

    private Throwable findWebException(Throwable ex) {
        if (ex instanceof WebException) {
            return ex;
        }
        for (Throwable inner_ex = ex.getCause(); inner_ex != null; inner_ex = inner_ex.getCause()) {
            if (!(inner_ex instanceof WebException)) continue;
            return inner_ex;
        }
        return ErrorAnalyser.findRootCause((Throwable)ex);
    }
}

