/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class HttpSslContext {
    private final int _sslPort;
    private final String keyPasswordStr;
    private final String keyStoreLocation;
    private final String keyStorePasswordStr;

    public HttpSslContext(int _sslPort, String keyStoreLocation, String keyStorePasswordStr, String keyPasswordStr) {
        if (StringUtils.isBlank((CharSequence)keyStoreLocation)) {
            throw new IllegalArgumentException("Invalid keystore location provided");
        }
        if (StringUtils.isBlank((CharSequence)keyStorePasswordStr)) {
            throw new IllegalArgumentException("Invalid keystore password provided");
        }
        if (StringUtils.isBlank((CharSequence)keyPasswordStr)) {
            throw new IllegalArgumentException("Invalid key password provided");
        }
        this._sslPort = _sslPort;
        this.keyStoreLocation = keyStoreLocation;
        this.keyStorePasswordStr = keyStorePasswordStr;
        this.keyPasswordStr = keyPasswordStr;
    }

    public int getSslPort() {
        return this._sslPort;
    }

    public SSLContext getSSLContext() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        char[] KEYSTOREPW = this.keyStorePasswordStr.toCharArray();
        char[] KEYPW = this.keyPasswordStr.toCharArray();
        keyStore.load(new FileInputStream(this.keyStoreLocation), KEYSTOREPW);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, KEYPW);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext;
    }
}

