/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.caudexorigo.http.netty4.DefaultObserver;
import org.caudexorigo.http.netty4.HttpProtocolHandler;
import org.caudexorigo.http.netty4.HttpSslContext;
import org.caudexorigo.http.netty4.NettyHttpServerInitializer;
import org.caudexorigo.http.netty4.NettySslHttpServerInitializer;
import org.caudexorigo.http.netty4.RequestObserver;
import org.caudexorigo.http.netty4.RequestRouter;
import org.caudexorigo.http.netty4.reporting.ResponseFormatter;
import org.caudexorigo.http.netty4.reporting.StandardResponseFormatter;
import org.caudexorigo.netty.DefaultNettyContext;
import org.caudexorigo.netty.NettyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer {
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_MAX_CONTENT_LENGHT = 0x400000;
    private static Logger log = LoggerFactory.getLogger(NettyHttpServer.class);
    private String _host;
    private RequestRouter _mapper;
    private RequestObserver _requestObserver;
    private ResponseFormatter _rspFmt;
    private int _port;
    private int _maxContentLenght = -1;
    private boolean _validate_headers;
    private NettyContext _nettyCtx;

    public NettyHttpServer() {
        this(DEFAULT_HOST, 8080);
    }

    public NettyHttpServer(int port) {
        this(DEFAULT_HOST, port);
    }

    public NettyHttpServer(String host, int port) {
        this._host = host;
        this._port = port;
        this._validate_headers = false;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public RequestRouter getRouter() {
        return this._mapper;
    }

    private boolean getValidateHeaders() {
        return this._validate_headers;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setRouter(RequestRouter mapper) {
        this._mapper = mapper;
    }

    public ResponseFormatter getResponseFormtter() {
        if (this._rspFmt != null) {
            return this._rspFmt;
        }
        return new StandardResponseFormatter(false);
    }

    public RequestObserver getRequestObserver() {
        if (this._requestObserver != null) {
            return this._requestObserver;
        }
        return new DefaultObserver();
    }

    public void setRequestObserver(RequestObserver requestObserver) {
        this._requestObserver = requestObserver;
    }

    public void setResponseFormatter(ResponseFormatter rspFmt) {
        this._rspFmt = rspFmt;
    }

    public void setValidateHeaders(boolean validate_headers) {
        this._validate_headers = validate_headers;
    }

    public void setMaxContentLenght(int maxContentLenght) {
        this._maxContentLenght = maxContentLenght;
    }

    public synchronized void start() {
        log.info("Starting Httpd");
        NettyContext nctx = this.getNettyContext();
        EventLoopGroup bossGroup = nctx.getBossEventLoopGroup();
        EventLoopGroup workerGroup = nctx.getWorkerEventLoopGroup();
        try {
            Class serverChannelClass = nctx.getServerChannelClass();
            NettyHttpServerInitializer server_init = new NettyHttpServerInitializer(this._mapper, this.getRequestObserver(), this.getResponseFormtter(), this.getMaxContentLength(), this.getValidateHeaders());
            ServerBootstrap b = new ServerBootstrap();
            this.setupBootStrap(b);
            ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(serverChannelClass)).childHandler((ChannelHandler)server_init);
            InetSocketAddress inet = new InetSocketAddress(this._host, this._port);
            log.info("Httpd started. Listening on {}:{}", (Object)this._host, (Object)this._port);
            b.bind((SocketAddress)inet).sync().channel().closeFuture().sync();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.stop(bossGroup, workerGroup);
        }
    }

    public int getMaxContentLength() {
        if (this._maxContentLenght > 0) {
            return this._maxContentLenght;
        }
        return 0x400000;
    }

    public synchronized void startSsl(HttpSslContext http_ssl_ctx) {
        SSLContext sslContext;
        log.info("Starting Httpd - SSL");
        NettyContext nctx = this.getNettyContext();
        EventLoopGroup bossGroup = nctx.getBossEventLoopGroup();
        EventLoopGroup workerGroup = nctx.getWorkerEventLoopGroup();
        try {
            sslContext = http_ssl_ctx.getSSLContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            HttpProtocolHandler http_handler = new HttpProtocolHandler(this._mapper, this.getRequestObserver(), this.getResponseFormtter());
            NettySslHttpServerInitializer server_init = new NettySslHttpServerInitializer(sslContext, http_handler);
            ServerBootstrap b = new ServerBootstrap();
            this.setupBootStrap(b);
            Class serverChannelClass = nctx.getServerChannelClass();
            ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(serverChannelClass)).childHandler((ChannelHandler)server_init);
            b.bind(http_ssl_ctx.getSslPort()).sync().channel().closeFuture().sync();
            log.info("Httpd SSL started. Listening on port: {}", (Object)http_ssl_ctx.getSslPort());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.stop(bossGroup, workerGroup);
        }
    }

    private void setupBootStrap(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)this.getNettyContext().getAllocator());
        bootstrap.childOption(ChannelOption.MAX_MESSAGES_PER_READ, (Object)Integer.MAX_VALUE);
        bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)Integer.MAX_VALUE);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
    }

    private NettyContext getNettyContext() {
        if (this._nettyCtx == null) {
            this._nettyCtx = DefaultNettyContext.get();
        }
        return this._nettyCtx;
    }

    public void setNettyContext(NettyContext nettyCtx) {
        this._nettyCtx = nettyCtx;
    }

    private void stop(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
        try {
            bossGroup.terminationFuture().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            workerGroup.terminationFuture().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

