/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import org.caudexorigo.http.netty4.HttpProtocolHandler;
import org.caudexorigo.http.netty4.RequestObserver;
import org.caudexorigo.http.netty4.RequestRouter;
import org.caudexorigo.http.netty4.reporting.ResponseFormatter;

public class NettyHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private boolean validate_headers;
    private final RequestRouter mapper;
    private final RequestObserver requestObserver;
    private final ResponseFormatter responseFormatter;
    private int maxContentLength;

    public NettyHttpServerInitializer(RequestRouter mapper, RequestObserver requestObserver, ResponseFormatter responseFormatter, int maxLength, boolean validate_headers) {
        this.mapper = mapper;
        this.requestObserver = requestObserver;
        this.responseFormatter = responseFormatter;
        this.maxContentLength = maxLength;
        this.validate_headers = validate_headers;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        int maxInitialLineLength = 4096;
        int maxHeaderSize = 8192;
        int maxChunkSize = 8192;
        pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder(maxInitialLineLength, maxHeaderSize, maxChunkSize, this.validate_headers));
        pipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
        pipeline.addLast("http-protocol-handler", (ChannelHandler)new HttpProtocolHandler(this.mapper, this.requestObserver, this.responseFormatter));
    }
}

