/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.text.UrlCodec;

public class NettyRequest {
    private static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String X_WWW_FORM_URLENCODED_UTF8 = "application/x-www-form-urlencoded; charset=UTF-8";
    private Charset charset;
    private String charsetName;
    private Map<String, List<String>> parameters;
    private String path;
    private String queryString;
    private FullHttpRequest request;

    public NettyRequest(FullHttpRequest request) {
        this(request, null);
    }

    public NettyRequest(FullHttpRequest request, Charset charset) {
        this.request = request;
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        this.charsetName = this.charset.displayName();
    }

    private void initParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, List<String>>();
            this.setParameters(this.getQueryString());
            String content_type = this.request.headers().get("Content-Type");
            if (this.request.getMethod().equals((Object)HttpMethod.POST) && StringUtils.contains((CharSequence)content_type, (CharSequence)X_WWW_FORM_URLENCODED) && HttpHeaders.getContentLength((HttpMessage)this.request) > 0L) {
                if (StringUtils.contains((CharSequence)content_type, (CharSequence)UTF8_CHARSET_NAME)) {
                    this.charset = UTF8_CHARSET;
                }
                this.setParameters(this.request.content().toString(this.charset));
            }
        }
    }

    public String getCharacterEncoding() {
        return this.charsetName;
    }

    public void setCharacterEncoding(String encoding) {
        this.charset = Charset.forName(encoding);
        this.charsetName = this.charset.displayName();
    }

    public void addHeader(String name, Object value) {
        this.request.headers().set(name, value);
    }

    public void addParameter(String name, String value) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    public void clearHeaders() {
        this.request.headers().clear();
    }

    public boolean containsHeader(String name) {
        return this.request.headers().contains(name);
    }

    public ByteBuf getContent() {
        return this.request.content();
    }

    public long getContentLength() {
        String contentLength = this.getHeader("Content-Length".toString());
        if (contentLength != null) {
            return Long.parseLong(contentLength);
        }
        return 0L;
    }

    public String getHeader(String name) {
        return this.request.headers().get(name);
    }

    public Set<String> getHeaderNames() {
        return this.request.headers().names();
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.request.headers().entries();
    }

    public List<String> getHeaders(String name) {
        return this.request.headers().getAll(name);
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String name) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public Map<String, List<String>> getParameters() {
        this.initParameters();
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<String> getParameters(String name) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = StringUtils.substringBefore((String)this.request.getUri(), (String)"?");
        }
        return this.path;
    }

    public HttpVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public String getQueryString() {
        if (this.queryString == null) {
            this.queryString = StringUtils.substringAfter((String)this.request.getUri(), (String)"?");
        }
        return this.queryString;
    }

    public String getUri() {
        return this.request.getUri();
    }

    public boolean isChunked() {
        return HttpHeaders.isTransferEncodingChunked((HttpMessage)this.request);
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive((HttpMessage)this.request);
    }

    public void removeHeader(String name) {
        this.request.headers().remove(name);
    }

    public void setHeader(String name, Iterable<?> values) {
        this.request.headers().set(name, values);
    }

    public void setHeader(String name, Object value) {
        this.request.headers().set(name, value);
    }

    public void setMethod(HttpMethod httpMethod) {
        this.request.setMethod(httpMethod);
    }

    private void setParameters(String parameters) {
        try {
            this.setParameters(parameters, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(this.charsetName + " decoder must be provided by JDK.");
        }
    }

    private void setParameters(String parameters, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)parameters)) {
            return;
        }
        int pos = 0;
        while (pos < parameters.length()) {
            String value;
            int ampPos = parameters.indexOf(38, pos);
            if (ampPos < 0) {
                value = parameters.substring(pos);
                ampPos = parameters.length();
            } else {
                value = parameters.substring(pos, ampPos);
            }
            int equalPos = value.indexOf(61);
            if (equalPos < 0) {
                this.addParameter(UrlCodec.decode((String)value, (String)encoding), "");
            } else {
                this.addParameter(UrlCodec.decode((String)value.substring(0, equalPos), (String)encoding), UrlCodec.decode((String)value.substring(equalPos + 1), (String)encoding));
            }
            pos = ampPos + 1;
        }
    }

    public void setProtocolVersion(HttpVersion hversion) {
        this.request.setProtocolVersion(hversion);
    }

    public void setUri(String uri) {
        this.request.setUri(uri);
    }
}

