/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import nu.xom.Attribute;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.jpt.JptNode;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class JptAttributeNode
extends JptNode {
    private String _attr_exp;
    private char[] _attribute_name;
    private static final char[] EQUAL_SIGN = "=".toCharArray();
    private static final char[] QUOTE = "\"".toCharArray();
    private static final char[] SPACE = " ".toCharArray();
    private boolean _isInSlot;
    private Serializable _compiled_exp;

    JptAttributeNode(Attribute attribute, boolean isInSlot) {
        this._isInSlot = isInSlot;
        this._attribute_name = attribute.getQualifiedName().toCharArray();
        this._attr_exp = attribute.getValue().replace("'", "\"").trim();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public JptNode getChild(int i) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        try {
            String v;
            if (this._compiled_exp == null) {
                ParserContext parser_context = ParserContext.create();
                Set<Map.Entry<String, Object>> ctx_entries = context.entrySet();
                for (Map.Entry<String, Object> entry : ctx_entries) {
                    parser_context.addInput(entry.getKey(), entry.getValue().getClass());
                }
                this._compiled_exp = MVEL.compileExpression((String)this._attr_exp, (ParserContext)parser_context);
            }
            if (StringUtils.isNotBlank((CharSequence)(v = String.valueOf(MVEL.executeExpression((Object)this._compiled_exp, context))))) {
                String sout = StringEscapeUtils.escapeXml((String)v);
                out.write(SPACE, 0, 1);
                out.write(this._attribute_name, 0, this._attribute_name.length);
                out.write(EQUAL_SIGN, 0, 1);
                out.write(QUOTE, 0, 1);
                out.write(sout);
                out.write(QUOTE, 0, 1);
            }
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            throw new RuntimeException(String.format("Error processing JptAttributeNode:%nexpression: '%s';%ncontext: %s;%nmessage: '%s'", this._attr_exp, context, r.getMessage()));
        }
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }
}

