/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JptConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JptConfiguration.class);
    private static final String CONFIG_FILE = "/jpt.config";
    private static final boolean DEFAULT_CHECK_MODIFIED = true;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final boolean DEFAULT_FULL_ERRORS = false;
    private String _active_enviroment;
    private boolean _check_modified;
    private boolean _full_errors;
    private String _encoding;
    private String _xml_reader_class;
    private static JptConfiguration instance = new JptConfiguration();

    private JptConfiguration() {
        try {
            this._active_enviroment = JptConfiguration.textValueFromPath("/config/active-enviroment/text()");
            this._check_modified = Boolean.parseBoolean(JptConfiguration.textValueFromPath("/config/enviroment/" + this._active_enviroment + "/check-modified/text()"));
            this._full_errors = Boolean.parseBoolean(JptConfiguration.textValueFromPath("/config/enviroment/" + this._active_enviroment + "/full-errors/text()"));
            this._encoding = JptConfiguration.textValueFromPath("/config/enviroment/" + this._active_enviroment + "/encoding/text()");
            this._encoding = StringUtils.isBlank((CharSequence)this._encoding) ? DEFAULT_ENCODING : this._encoding.trim();
            this._xml_reader_class = JptConfiguration.textValueFromPath("/config/enviroment/" + this._active_enviroment + "/parser/text()");
        }
        catch (Throwable t) {
            log.warn("Error reading configuration check your \"{}\" file. Detail: {}", (Object)CONFIG_FILE, (Object)t.getMessage());
            this._active_enviroment = "";
            this._check_modified = true;
            this._encoding = DEFAULT_ENCODING;
            this._full_errors = false;
            this._xml_reader_class = "";
        }
    }

    private static String textValueFromPath(String pathExpression) {
        try {
            Object pad = new Object();
            InputSource configFile = new InputSource(pad.getClass().getResourceAsStream(CONFIG_FILE));
            if (configFile.getByteStream() == null) {
                throw new RuntimeException("file \"/jpt.config\" not found in path.");
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expression = xpath.compile(pathExpression);
            String result = expression.evaluate(configFile);
            return result == null ? "" : result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Xpath:\"%s\" not found in document!", pathExpression), e);
        }
    }

    public static String active_enviroment() {
        return JptConfiguration.instance._active_enviroment;
    }

    public static boolean checkModified() {
        return JptConfiguration.instance._check_modified;
    }

    public static boolean fullErrors() {
        return JptConfiguration.instance._full_errors;
    }

    public static String encoding() {
        return JptConfiguration.instance._encoding;
    }

    public static String xmlReaderClass() {
        return JptConfiguration.instance._xml_reader_class;
    }
}

