/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.jpt.JptNode;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class JptTemplateNode
extends JptNode {
    private boolean _isInSlot;
    private CompiledTemplate _compiled_template;
    private String _template;

    JptTemplateNode(String template, boolean isInSlot) {
        this._template = StringEscapeUtils.unescapeXml((String)template);
        this._isInSlot = isInSlot;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public JptNode getChild(int i) {
        throw new IndexOutOfBoundsException("Output Expressions do not have children");
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        try {
            if (this._compiled_template == null) {
                ParserContext parser_context = ParserContext.create();
                Set<Map.Entry<String, Object>> ctx_entries = context.entrySet();
                for (Map.Entry<String, Object> entry : ctx_entries) {
                    parser_context.addInput(entry.getKey(), entry.getValue().getClass());
                }
                this._compiled_template = TemplateCompiler.compileTemplate((String)this._template, (ParserContext)parser_context);
            }
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            throw new RuntimeException(String.format("Error processing template:%ncontext: %s;%nmessage: '%s'", context, r.getMessage()));
        }
        String sout = String.valueOf(TemplateRuntime.execute((CompiledTemplate)this._compiled_template, context));
        out.write(sout);
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }
}

