/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.codec.thrift;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.codec.thrift.Accepted;
import pt.com.broker.codec.thrift.Acknowledge;
import pt.com.broker.codec.thrift.Action;
import pt.com.broker.codec.thrift.ActionType;
import pt.com.broker.codec.thrift.Atom;
import pt.com.broker.codec.thrift.Authentication;
import pt.com.broker.codec.thrift.BrokerMessage;
import pt.com.broker.codec.thrift.DestinationType;
import pt.com.broker.codec.thrift.Fault;
import pt.com.broker.codec.thrift.Header;
import pt.com.broker.codec.thrift.Notification;
import pt.com.broker.codec.thrift.Ping;
import pt.com.broker.codec.thrift.Poll;
import pt.com.broker.codec.thrift.Pong;
import pt.com.broker.codec.thrift.Publish;
import pt.com.broker.codec.thrift.Subscribe;
import pt.com.broker.codec.thrift.Unsubscribe;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAcknowledge;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetAuthentication;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetPing;
import pt.com.broker.types.NetPoll;
import pt.com.broker.types.NetPong;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetPublish;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetUnsubscribe;
import pt.com.broker.types.stats.EncodingStats;

public class ThriftBindingSerializer
implements BindingSerializer {
    private static final Logger log = LoggerFactory.getLogger(ThriftBindingSerializer.class);

    private static NetAction.ActionType translateActionType(ActionType actionType) {
        switch (actionType) {
            case ACCEPTED: {
                return NetAction.ActionType.ACCEPTED;
            }
            case ACKNOWLEDGE: {
                return NetAction.ActionType.ACKNOWLEDGE;
            }
            case FAULT: {
                return NetAction.ActionType.FAULT;
            }
            case PING: {
                return NetAction.ActionType.PING;
            }
            case PONG: {
                return NetAction.ActionType.PONG;
            }
            case NOTIFICATION: {
                return NetAction.ActionType.NOTIFICATION;
            }
            case POLL: {
                return NetAction.ActionType.POLL;
            }
            case PUBLISH: {
                return NetAction.ActionType.PUBLISH;
            }
            case SUBSCRIBE: {
                return NetAction.ActionType.SUBSCRIBE;
            }
            case UNSUBSCRIBE: {
                return NetAction.ActionType.UNSUBSCRIBE;
            }
            case AUTH: {
                return NetAction.ActionType.AUTH;
            }
        }
        throw new RuntimeException("Unexpected ActionType: " + (Object)((Object)actionType));
    }

    private static NetAction.DestinationType translateDestinationType(DestinationType destinationType) {
        switch (destinationType) {
            case QUEUE: {
                return NetAction.DestinationType.QUEUE;
            }
            case TOPIC: {
                return NetAction.DestinationType.TOPIC;
            }
            case VIRTUAL_QUEUE: {
                return NetAction.DestinationType.VIRTUAL_QUEUE;
            }
        }
        throw new RuntimeException("Unexpected detination type: " + (Object)((Object)destinationType));
    }

    private NetMessage constructMessage(Atom tm) {
        NetMessage message = new NetMessage(this.extractAction(tm.getAction()), tm.header == null ? null : tm.header.parameters);
        return message;
    }

    private NetAccepted extractAcceptedMessage(Action action) {
        NetAccepted netAccepted = new NetAccepted(action.getAccepted().getAction_id());
        return netAccepted;
    }

    private NetAcknowledge extractAcknowledgeMessage(Action action) {
        Acknowledge ThriftAckMsg = action.getAck_message();
        String destination = ThriftAckMsg.getDestination();
        String messageId = ThriftAckMsg.getMessage_id();
        NetAcknowledge ackMessage = new NetAcknowledge(destination, messageId);
        if (action.getAck_message().isSetAction_id()) {
            ackMessage.setActionId(action.getAck_message().getAction_id());
        }
        return ackMessage;
    }

    private NetAction extractAction(Action action) {
        NetAction.ActionType actionType = ThriftBindingSerializer.translateActionType(action.getAction_type());
        NetAction netAction = new NetAction(actionType);
        switch (actionType) {
            case ACCEPTED: {
                netAction.setAcceptedMessage(this.extractAcceptedMessage(action));
                break;
            }
            case ACKNOWLEDGE: {
                netAction.setAcknowledgeMessage(this.extractAcknowledgeMessage(action));
                break;
            }
            case FAULT: {
                netAction.setFaultMessage(this.extractFaultMessage(action));
                break;
            }
            case NOTIFICATION: {
                netAction.setNotificationMessage(this.extractNotificationMessage(action));
                break;
            }
            case POLL: {
                netAction.setPollMessage(this.extractPollMessage(action));
                break;
            }
            case PUBLISH: {
                netAction.setPublishMessage(this.extractPublishMessage(action));
                break;
            }
            case SUBSCRIBE: {
                netAction.setSubscribeMessage(this.extractSubscribeMessage(action));
                break;
            }
            case UNSUBSCRIBE: {
                netAction.setUnsbuscribeMessage(this.extractUnsubscribeMessage(action));
                break;
            }
            case PING: {
                netAction.setPingMessage(this.extractPingMessage(action));
                break;
            }
            case PONG: {
                netAction.setPongMessage(this.extractPongMessage(action));
                break;
            }
            case AUTH: {
                netAction.setAuthenticationMessage(this.extractAuthenticationMessage(action));
            }
        }
        return netAction;
    }

    private NetAuthentication extractAuthenticationMessage(Action action) {
        Authentication auth = action.getAuth();
        NetAuthentication netAuthentication = new NetAuthentication(auth.getToken(), auth.getAuthentication_type());
        netAuthentication.setActionId(auth.getAction_id());
        netAuthentication.setRoles(auth.getRoles());
        netAuthentication.setUserId(auth.getUser_id());
        return netAuthentication;
    }

    private NetFault extractFaultMessage(Action action) {
        Fault fault = action.getFault();
        String code = fault.getFault_code();
        String message = fault.getFault_message();
        NetFault netFault = new NetFault(code, message);
        if (fault.isSetAction_id()) {
            netFault.setActionId(fault.getAction_id());
        }
        if (fault.isSetFault_detail()) {
            netFault.setDetail(fault.getFault_detail());
        }
        return netFault;
    }

    private NetNotification extractNotificationMessage(Action action) {
        Notification notification = action.getNotification();
        String dest = notification.getDestination();
        NetAction.DestinationType destType = ThriftBindingSerializer.translateDestinationType(notification.getDestination_type());
        NetBrokerMessage brkMsg = this.obtainBrokerMessage(notification.getMessage());
        String subs = notification.getSubscription();
        NetNotification netNotification = new NetNotification(dest, destType, brkMsg, subs);
        return netNotification;
    }

    private NetPing extractPingMessage(Action action) {
        Ping ping = action.getPing();
        NetPing netPing = new NetPing(ping.getAction_id());
        return netPing;
    }

    private NetPoll extractPollMessage(Action action) {
        Poll poll = action.getPoll();
        String destination = poll.getDestination();
        NetPoll pollMsg = new NetPoll(destination, poll.getTimeout());
        if (poll.isSetAction_id()) {
            pollMsg.setActionId(poll.getAction_id());
        }
        return pollMsg;
    }

    private NetPong extractPongMessage(Action action) {
        Pong pong = action.getPong();
        NetPong netPong = new NetPong(pong.getAction_id());
        return netPong;
    }

    private NetPublish extractPublishMessage(Action action) {
        Publish pub = action.getPublish();
        String dest = pub.getDestination();
        NetAction.DestinationType destType = ThriftBindingSerializer.translateDestinationType(pub.getDestination_type());
        NetBrokerMessage brkMsg = this.obtainBrokerMessage(pub.getMessage());
        NetPublish netPub = new NetPublish(dest, destType, brkMsg);
        if (pub.isSetAction_id()) {
            netPub.setActionId(pub.getAction_id());
        }
        return netPub;
    }

    private NetSubscribe extractSubscribeMessage(Action action) {
        Subscribe subs = action.getSubscribe();
        String dest = subs.getDestination();
        NetAction.DestinationType destType = ThriftBindingSerializer.translateDestinationType(subs.getDestination_type());
        NetSubscribe netSubs = new NetSubscribe(dest, destType);
        if (subs.isSetAction_id()) {
            netSubs.setActionId(subs.getAction_id());
        }
        return netSubs;
    }

    private NetUnsubscribe extractUnsubscribeMessage(Action action) {
        Unsubscribe unsubs = action.getUnsubscribe();
        String dest = unsubs.getDestination();
        NetAction.DestinationType destType = ThriftBindingSerializer.translateDestinationType(unsubs.getDestination_type());
        NetUnsubscribe cgsUnsubs = new NetUnsubscribe(dest, destType);
        if (unsubs.isSetAction_id()) {
            cgsUnsubs.setActionId(unsubs.getAction_id());
        }
        return cgsUnsubs;
    }

    private Accepted getAccepted(NetMessage netMessage) {
        NetAccepted netAccepted = netMessage.getAction().getAcceptedMessage();
        Accepted struct = new Accepted();
        struct.setAction_id(netAccepted.getActionId());
        return struct;
    }

    private Acknowledge getAcknowledge(NetMessage netMessage) {
        NetAcknowledge net = netMessage.getAction().getAcknowledgeMessage();
        Acknowledge struct = new Acknowledge();
        struct.setDestination(net.getDestination());
        struct.setMessage_id(net.getMessageId());
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        return struct;
    }

    private Action getAction(NetMessage netMessage) {
        Action ac = new Action();
        switch (netMessage.getAction().getActionType()) {
            case ACCEPTED: {
                ac.setAction_type(ActionType.ACCEPTED);
                ac.setAccepted(this.getAccepted(netMessage));
                break;
            }
            case ACKNOWLEDGE: {
                ac.setAction_type(ActionType.ACKNOWLEDGE);
                ac.setAck_message(this.getAcknowledge(netMessage));
                break;
            }
            case FAULT: {
                ac.setAction_type(ActionType.FAULT);
                ac.setFault(this.getFault(netMessage));
                break;
            }
            case NOTIFICATION: {
                ac.setAction_type(ActionType.NOTIFICATION);
                ac.setNotification(this.getNotification(netMessage));
                break;
            }
            case POLL: {
                ac.setAction_type(ActionType.POLL);
                ac.setPoll(this.getPoll(netMessage));
                break;
            }
            case PUBLISH: {
                ac.setAction_type(ActionType.PUBLISH);
                ac.setPublish(this.getPublish(netMessage));
                break;
            }
            case SUBSCRIBE: {
                ac.setAction_type(ActionType.SUBSCRIBE);
                ac.setSubscribe(this.getSubscribe(netMessage));
                break;
            }
            case UNSUBSCRIBE: {
                ac.setAction_type(ActionType.UNSUBSCRIBE);
                ac.setUnsubscribe(this.getUnsubscribe(netMessage));
                break;
            }
            case PING: {
                ac.setAction_type(ActionType.PING);
                ac.setPing(this.getPing(netMessage));
                break;
            }
            case PONG: {
                ac.setAction_type(ActionType.PONG);
                ac.setPong(this.getPong(netMessage));
                break;
            }
            case AUTH: {
                ac.setAction_type(ActionType.AUTH);
                ac.setAuth(this.getAuth(netMessage));
            }
        }
        return ac;
    }

    private Authentication getAuth(NetMessage netMessage) {
        NetAuthentication netAuthentication = netMessage.getAction().getAuthenticationMessage();
        Authentication auth = new Authentication();
        auth.setAction_id(netAuthentication.getActionId());
        auth.setAuthentication_type(netAuthentication.getAuthenticationType());
        auth.setToken(netAuthentication.getToken());
        auth.setUser_id(netAuthentication.getUserId());
        auth.setRoles(netAuthentication.getRoles());
        return auth;
    }

    private Fault getFault(NetMessage netMessage) {
        NetFault net = netMessage.getAction().getFaultMessage();
        Fault struct = new Fault();
        struct.setFault_code(net.getCode());
        struct.setFault_message(net.getMessage());
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        if (net.getDetail() != null) {
            struct.setFault_detail(net.getDetail());
        }
        return struct;
    }

    private Header getHeaders(NetMessage netMessage) {
        Header header = new Header();
        header.setParameters(netMessage.getHeaders());
        return header;
    }

    private BrokerMessage getMessageBroker(NetBrokerMessage message) {
        BrokerMessage struct = new BrokerMessage();
        struct.setPayload(message.getPayload());
        struct.setMessage_id(message.getMessageId());
        struct.setExpiration(message.getExpiration());
        struct.setTimestamp(message.getTimestamp());
        return struct;
    }

    private Notification getNotification(NetMessage netMessage) {
        NetNotification net = netMessage.getAction().getNotificationMessage();
        String subs = net.getSubscription();
        if (subs == null) {
            subs = "";
        }
        Notification struct = new Notification();
        struct.setDestination(net.getDestination());
        struct.setMessage(this.getMessageBroker(net.getMessage()));
        struct.setDestination_type(this.translate(net.getDestinationType()));
        struct.setSubscription(subs);
        return struct;
    }

    private Ping getPing(NetMessage netMessage) {
        NetPing netPing = netMessage.getAction().getPingMessage();
        Ping struct = new Ping();
        struct.setAction_id(netPing.getActionId());
        return struct;
    }

    private Poll getPoll(NetMessage netMessage) {
        NetPoll net = netMessage.getAction().getPollMessage();
        Poll struct = new Poll();
        struct.setDestination(net.getDestination());
        struct.setTimeout(net.getTimeout());
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        return struct;
    }

    private Pong getPong(NetMessage netMessage) {
        NetPong netPong = netMessage.getAction().getPongMessage();
        Pong struct = new Pong();
        struct.setAction_id(netPong.getActionId());
        return struct;
    }

    private Publish getPublish(NetMessage netMessage) {
        NetPublish net = netMessage.getAction().getPublishMessage();
        Publish struct = new Publish();
        struct.setDestination(net.getDestination());
        struct.setMessage(this.getMessageBroker(net.getMessage()));
        struct.setDestination_type(this.translate(net.getDestinationType()));
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        return struct;
    }

    private Subscribe getSubscribe(NetMessage netMessage) {
        NetSubscribe net = netMessage.getAction().getSubscribeMessage();
        Subscribe struct = new Subscribe();
        struct.setDestination(net.getDestination());
        struct.setDestination_type(this.translate(net.getDestinationType()));
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        return struct;
    }

    private Unsubscribe getUnsubscribe(NetMessage netMessage) {
        NetUnsubscribe net = netMessage.getAction().getUnsbuscribeMessage();
        Unsubscribe struct = new Unsubscribe();
        struct.setDestination(net.getDestination());
        struct.setDestination_type(this.translate(net.getDestinationType()));
        if (net.getActionId() != null) {
            struct.setAction_id(net.getActionId());
        }
        return struct;
    }

    public byte[] marshal(NetMessage netMessage) {
        byte[] result = null;
        try {
            Atom tm = new Atom();
            Header header = this.getHeaders(netMessage);
            Action ac = this.getAction(netMessage);
            if (header != null) {
                tm.setHeader(header);
            }
            if (ac != null) {
                tm.setAction(ac);
            }
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            result = serializer.serialize((TBase)tm);
            EncodingStats.newThriftEncodedMessage();
        }
        catch (Throwable e) {
            log.error("Error parsing Protocol Buffer message.", (Object)e.getMessage());
        }
        return result;
    }

    public void marshal(NetMessage message, OutputStream out) {
        try {
            out.write(this.marshal(message));
            EncodingStats.newThriftEncodedMessage();
        }
        catch (Throwable e) {
            log.error("Error parsing Protocol Buffer message.", (Object)e.getMessage());
        }
    }

    private NetBrokerMessage obtainBrokerMessage(BrokerMessage message) {
        NetBrokerMessage brkMsg = new NetBrokerMessage(message.getPayload());
        if (message.getTimestamp() != -1L) {
            brkMsg.setTimestamp(message.getTimestamp());
        }
        if (message.getExpiration() != -1L) {
            brkMsg.setExpiration(message.getExpiration());
        }
        if (StringUtils.isNotBlank((CharSequence)message.getMessage_id())) {
            brkMsg.setMessageId(message.getMessage_id());
        }
        return brkMsg;
    }

    private DestinationType translate(NetAction.DestinationType destinationType) {
        switch (destinationType) {
            case QUEUE: {
                return DestinationType.QUEUE;
            }
            case TOPIC: {
                return DestinationType.TOPIC;
            }
            case VIRTUAL_QUEUE: {
                return DestinationType.VIRTUAL_QUEUE;
            }
        }
        throw new RuntimeException("Unexpected detination type: " + destinationType);
    }

    public NetMessage unmarshal(byte[] packet) {
        NetMessage message = null;
        try {
            Atom tm = new Atom();
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize((TBase)tm, packet);
            message = this.constructMessage(tm);
            EncodingStats.newThriftDecodedMessage();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return message;
    }

    public NetMessage unmarshal(InputStream in) {
        NetMessage message = null;
        try {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
            int b = 0;
            while ((b = in.read()) < -1) {
                out.write(b);
            }
            Atom tm = new Atom();
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize((TBase)tm, out.toByteArray());
            message = this.constructMessage(tm);
            EncodingStats.newThriftDecodedMessage();
        }
        catch (Throwable e) {
            log.error("Error parsing Thrift message.", e);
        }
        return message;
    }

    public NetProtocolType getProtocolType() {
        return NetProtocolType.THRIFT;
    }
}

