/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.bootstrap.BaseBootstrap;
import pt.com.broker.client.nio.codecs.BindingSerializerFactory;
import pt.com.broker.client.nio.exceptions.UnavailableAgentException;
import pt.com.broker.client.nio.server.HostContainer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelWrapperFuture;
import pt.com.broker.client.nio.utils.HostInfoFuture;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetPublish;

public abstract class BaseClient {
    private static final Logger log = LoggerFactory.getLogger(BaseClient.class);
    protected HostContainer hosts;
    BaseBootstrap bootstrap;
    BindingSerializer serializer = null;
    NetProtocolType protocolType = NetProtocolType.JSON;

    public BaseClient(NetProtocolType ptype) {
        this.setProtocolType(ptype);
        this.init();
    }

    public BaseClient(String host, int port) {
        this(new HostInfo(host, port), NetProtocolType.PROTOCOL_BUFFER);
    }

    public BaseClient(String host, int port, NetProtocolType ptype) {
        this(new HostInfo(host, port), ptype);
    }

    public BaseClient(HostInfo host, NetProtocolType ptype) {
        this(ptype);
        this.addServer(host);
    }

    protected HostInfoFuture sendNetMessage(NetMessage msg) {
        try {
            HostInfo host = this.getAvailableHost();
            return this.sendNetMessage(msg, host);
        }
        catch (Exception e) {
            return new HostNotAvailableFuture();
        }
    }

    protected ChannelWrapperFuture sendNetMessage(NetMessage msg, HostInfo host) {
        Channel channel = host.getChannel();
        if (channel == null) {
            throw new RuntimeException("Host not connected");
        }
        ChannelFuture f = channel.writeAndFlush((Object)msg);
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    log.error("Error sending message!!! Message lost", future.cause());
                }
            }
        });
        return new ChannelWrapperFuture(f);
    }

    protected NetMessage buildMessage(NetAction action, Map<String, String> headers) {
        NetMessage message = new NetMessage(action, headers);
        return message;
    }

    protected NetMessage buildMessage(NetAction action) {
        return this.buildMessage(action, new HashMap<String, String>());
    }

    public Future<HostInfo> publish(String brokerMessage, String destinationName, NetAction.DestinationType dtype) throws UnavailableAgentException {
        return this.publish(brokerMessage.getBytes(), destinationName, dtype);
    }

    public Future<HostInfo> publish(byte[] brokerMessage, String destinationName, NetAction.DestinationType dtype) throws UnavailableAgentException {
        NetBrokerMessage msg = new NetBrokerMessage(brokerMessage);
        return this.publish(msg, destinationName, dtype);
    }

    public Future<HostInfo> publish(NetBrokerMessage brokerMessage, String destination, NetAction.DestinationType dtype) throws UnavailableAgentException {
        if (brokerMessage == null || StringUtils.isBlank((CharSequence)destination)) {
            throw new IllegalArgumentException("Mal-formed Enqueue request");
        }
        NetPublish publish = new NetPublish(destination, dtype, brokerMessage);
        return this.publish(publish, destination, dtype);
    }

    public Future<HostInfo> publish(NetPublish message, String destination, NetAction.DestinationType dtype) throws UnavailableAgentException {
        NetAction action = new NetAction(message);
        return this.sendNetMessage(new NetMessage(action, message.getMessage().getHeaders()));
    }

    protected HostInfo getAvailableHost() {
        HostInfo h = null;
        h = this.getHosts().getAvailableHost();
        if (h == null) {
            throw new RuntimeException("Was not possible to get an active channel");
        }
        return h;
    }

    public HostInfo connect() {
        return this.hosts.connect();
    }

    public Future<HostInfo> connectAsync() {
        return this.hosts.connectAsync();
    }

    public HostContainer getHosts() {
        return this.hosts;
    }

    public void setHosts(HostContainer hosts) {
        this.hosts = hosts;
    }

    protected BaseBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(BaseBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public Future close() {
        this.getHosts().disconnect();
        return this.getBootstrap().shutdownGracefully();
    }

    public void addServer(HostInfo host) {
        this.getHosts().add(host);
    }

    public HostInfo addServer(String hostname, int port) {
        HostInfo host = new HostInfo(hostname, port);
        this.addServer(host);
        return host;
    }

    protected abstract void init();

    public NetProtocolType getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(NetProtocolType protocolType) {
        this.protocolType = protocolType;
        try {
            this.serializer = BindingSerializerFactory.getInstance(protocolType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected BindingSerializer getSerializer() {
        return this.serializer;
    }

    protected class HostNotAvailableFuture<T extends HostInfo>
    extends ExceptionFuture<T> {
        public HostNotAvailableFuture() {
            super(new Exception("No Host available to connect"));
        }
    }

    protected class HostNotConnected<T extends HostInfo>
    extends ExceptionFuture<T> {
        public HostNotConnected() {
            super(new Exception("No Host available to connect"));
        }
    }

    protected class ExceptionFuture<T extends HostInfo>
    extends HostInfoFuture {
        Exception exception;

        public ExceptionFuture(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public boolean cancel(boolean b) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            throw new ExecutionException(this.getException());
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.get();
        }
    }
}

