/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.bootstrap.BaseChannelInitializer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;

public abstract class BaseBootstrap {
    private static final Logger log = LoggerFactory.getLogger(BaseBootstrap.class);
    private final BaseChannelInitializer channelInitializer;
    private final EventLoopGroup group = new NioEventLoopGroup();

    public BaseBootstrap(BaseChannelInitializer channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    public ChannelFuture connect(final HostInfo hostInfo) {
        Bootstrap boot = this.getNewInstance();
        boot.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)hostInfo.getConnectTimeout());
        InetSocketAddress socketAddress = new InetSocketAddress(hostInfo.getHostname(), hostInfo.getPort());
        ChannelFuture f = boot.connect((SocketAddress)socketAddress);
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    ChannelDecorator channel = new ChannelDecorator(f.channel());
                    channel.setHost(hostInfo);
                    hostInfo.setChannel(channel);
                    hostInfo.setStatus(HostInfo.STATUS.OPEN);
                    f.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            hostInfo.setStatus(HostInfo.STATUS.CLOSED);
                            hostInfo.setChannel(null);
                        }
                    });
                } else {
                    hostInfo.setStatus(HostInfo.STATUS.CLOSED);
                }
            }
        });
        return f;
    }

    public BaseChannelInitializer getChannelInitializer() {
        return this.channelInitializer;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public abstract Bootstrap getNewInstance();

    public Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.group.shutdownGracefully(quietPeriod, timeout, unit);
    }
}

