/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.bootstrap;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.NioSocketChannelBroker;
import pt.com.broker.client.nio.bootstrap.BaseBootstrap;
import pt.com.broker.client.nio.bootstrap.BaseChannelInitializer;
import pt.com.broker.client.nio.server.HostInfo;

public class Bootstrap
extends BaseBootstrap {
    static final Logger log = LoggerFactory.getLogger(Bootstrap.class);

    public Bootstrap(BaseChannelInitializer channelInitializer) {
        super(channelInitializer);
    }

    @Override
    public io.netty.bootstrap.Bootstrap getNewInstance() {
        io.netty.bootstrap.Bootstrap bootstrap = new io.netty.bootstrap.Bootstrap();
        EventLoopGroup group = this.getGroup();
        ((io.netty.bootstrap.Bootstrap)bootstrap.group(group)).channel(NioSocketChannelBroker.class);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)new PooledByteBufAllocator(true));
        bootstrap.handler((ChannelHandler)this.getChannelInitializer());
        return bootstrap;
    }

    @Override
    public ChannelFuture connect(final HostInfo hostInfo) {
        ChannelFuture f = super.connect(hostInfo);
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    log.debug("Adding iddle state handler to the pipeline. Reader idle timeout: {}. Writter idle timeout: {}", (Object)hostInfo.getReaderIdleTime(), (Object)hostInfo.getWriterIdleTime());
                    IdleStateHandler idleStateHandler = new IdleStateHandler(hostInfo.getReaderIdleTime(), hostInfo.getWriterIdleTime(), 0L, TimeUnit.MILLISECONDS);
                    f.channel().pipeline().addFirst(new ChannelHandler[]{idleStateHandler});
                }
            }
        });
        return f;
    }
}

