/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.consumer;

import java.net.InetSocketAddress;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.consumer.BrokerAsyncConsumer;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.exceptions.ExistingSubscriptionException;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.types.DestinationDataDelegator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetSubscribeAction;

public class ConsumerManager {
    private static final Logger log = LoggerFactory.getLogger(ConsumerManager.class);
    protected final EnumMap<NetAction.DestinationType, Map<String, BrokerAsyncConsumer>> _consumerList = new EnumMap(NetAction.DestinationType.class);

    public ConsumerManager() {
        this._consumerList.put(NetAction.DestinationType.TOPIC, new ConcurrentHashMap());
        this._consumerList.put(NetAction.DestinationType.QUEUE, new ConcurrentHashMap());
    }

    public void addSubscription(NetSubscribeAction subscribe, BrokerListener listener, HostInfo hostInfo) {
        BrokerAsyncConsumer consumer = new BrokerAsyncConsumer(subscribe.getDestination(), subscribe.getDestinationType(), listener);
        consumer.setActionId(subscribe.getActionId());
        consumer.setHost(hostInfo);
        this.addSubscription(consumer);
    }

    private InetSocketAddress getSocket(HostInfo host) {
        InetSocketAddress socketAddress = new InetSocketAddress(host.getHostname(), host.getPort());
        return socketAddress;
    }

    private String getDestinationKey(String destination, NetAction.DestinationType destinationType, HostInfo host) {
        if (destinationType == NetAction.DestinationType.TOPIC) {
            return destination;
        }
        InetSocketAddress socketAddress = this.getSocket(host);
        if (StringUtils.isEmpty((CharSequence)destination)) {
            throw new IllegalArgumentException("Invalid Destination");
        }
        String hostname = socketAddress.getHostName();
        int port = socketAddress.getPort();
        return hostname + ":" + port + "#" + destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(BrokerAsyncConsumer consumer) {
        NetAction.DestinationType destinationType = consumer.getDestinationType();
        if (StringUtils.isEmpty((CharSequence)consumer.getDestinationName())) {
            throw new IllegalArgumentException("Invalid Destination name");
        }
        if (destinationType == null) {
            throw new IllegalArgumentException("Invalid Destination Type");
        }
        String destination = this.getDestinationKey(consumer.getDestinationName(), consumer.getDestinationType(), consumer.getHost());
        EnumMap<NetAction.DestinationType, Map<String, BrokerAsyncConsumer>> enumMap = this._consumerList;
        synchronized (enumMap) {
            Map<String, BrokerAsyncConsumer> subscriptions = this.getSubscriptions(destinationType);
            if (subscriptions.containsKey(destination)) {
                throw new ExistingSubscriptionException(String.format("A listener for the destination %s already exists", destination));
            }
            subscriptions.put(destination, consumer);
            log.info("Added Async Consumer for {} {} ", (Object)consumer.getHost(), (Object)consumer.getDestinationName());
        }
    }

    public BrokerAsyncConsumer removeSubscription(NetSubscribeAction netSubscribeAction, HostInfo host) {
        return this.removeSubscription(netSubscribeAction.getDestinationType(), netSubscribeAction.getDestination(), host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAsyncConsumer removeSubscription(NetAction.DestinationType destinationType, String destination, HostInfo host) {
        EnumMap<NetAction.DestinationType, Map<String, BrokerAsyncConsumer>> enumMap = this._consumerList;
        synchronized (enumMap) {
            Map<String, BrokerAsyncConsumer> subscriptions = this.getSubscriptions(destinationType);
            String key = this.getDestinationKey(destination, destinationType, host);
            BrokerAsyncConsumer brokerAsyncConsumer = subscriptions.remove(key);
            if (brokerAsyncConsumer != null) {
                log.debug("Removing key: " + key);
            }
            return brokerAsyncConsumer;
        }
    }

    public BrokerAsyncConsumer getConsumer(NetAction.DestinationType destinationType, String destination, HostInfo host) {
        Map<String, BrokerAsyncConsumer> subscriptions = this.getSubscriptions(destinationType);
        return subscriptions.get(this.getDestinationKey(destination, destinationType, host));
    }

    protected BrokerAsyncConsumer getConsumer(NetMessage netMessage, HostInfo host) {
        DestinationDataDelegator delegator = new DestinationDataDelegator(netMessage);
        String destination = delegator.getSubscription();
        NetAction.DestinationType dtype = delegator.getDestinationType();
        return this.getConsumer(dtype, destination, host);
    }

    public Map<String, BrokerAsyncConsumer> getSubscriptions(NetAction.DestinationType dtype) {
        NetAction.DestinationType type = NetAction.DestinationType.TOPIC.equals((Object)dtype) ? NetAction.DestinationType.TOPIC : NetAction.DestinationType.QUEUE;
        Map<String, BrokerAsyncConsumer> subscriptions = this._consumerList.get(type);
        return subscriptions;
    }

    public void deliverMessage(NetMessage netMessage, HostInfo host) throws Throwable {
        BrokerAsyncConsumer consumer = this.getConsumer(netMessage, host);
        if (consumer == null) {
            log.warn("No consumer found for message: " + netMessage);
            return;
        }
        consumer.deliver(netMessage, host);
    }

    public Map<String, BrokerAsyncConsumer> getSubscriptions(NetAction.DestinationType dtype, HostInfo host) {
        HashMap<String, BrokerAsyncConsumer> map = new HashMap<String, BrokerAsyncConsumer>();
        for (Map.Entry<String, BrokerAsyncConsumer> entry : this.getSubscriptions(dtype).entrySet()) {
            String key = entry.getKey();
            BrokerAsyncConsumer consumer = entry.getValue();
            if (!consumer.getHost().equals(host)) continue;
            map.put(key, consumer);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BrokerAsyncConsumer> removeSubscriptions(NetAction.DestinationType dtype, HostInfo host) {
        EnumMap<NetAction.DestinationType, Map<String, BrokerAsyncConsumer>> enumMap = this._consumerList;
        synchronized (enumMap) {
            HashMap<String, BrokerAsyncConsumer> map = new HashMap<String, BrokerAsyncConsumer>(2);
            for (Map.Entry<String, BrokerAsyncConsumer> entry : this.getSubscriptions(dtype).entrySet()) {
                String key = entry.getKey();
                BrokerAsyncConsumer consumer = entry.getValue();
                if (this.removeSubscription(dtype, consumer.getDestinationName(), host) == null) continue;
                map.put(key, consumer);
            }
            return map;
        }
    }
}

