/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.events;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;

public abstract class NotificationListenerAdapter
implements BrokerListener {
    private static final Logger log = LoggerFactory.getLogger(NotificationListenerAdapter.class);
    BrokerClient brokerClient;

    @Override
    public final void deliverMessage(NetMessage message, HostInfo host) throws Throwable {
        NetAction netAction = message.getAction();
        NetNotification netNotification = netAction.getNotificationMessage();
        if (netNotification != null) {
            if (this.onMessage(netNotification, host)) {
                if (this.brokerClient != null) {
                    if (netNotification.getDestinationType() != NetAction.DestinationType.TOPIC) {
                        this.brokerClient.acknowledge(netNotification, host);
                    }
                } else {
                    log.debug("Message not acknowledged because broker client was not set ");
                }
            }
        } else {
            log.error("Invalid Message");
        }
    }

    public final void setBrokerClient(BrokerClient client) {
        this.brokerClient = client;
    }

    public abstract boolean onMessage(NetNotification var1, HostInfo var2);
}

