/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.consumer.PongConsumerManager;
import pt.com.broker.client.nio.handlers.HeartBeatEventHandler;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.ActionIdDecorator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;

@ChannelHandler.Sharable
public class PongMessageHandler
extends SimpleChannelInboundHandler<NetMessage> {
    public static final String HEART_BEAT_ACTION_ID = "24bb963d-6d6c-441e-ab4d-999d73578452";
    private static final Logger log = LoggerFactory.getLogger(PongMessageHandler.class);
    PongConsumerManager manager;

    public PongMessageHandler(PongConsumerManager manager) {
        this.manager = manager;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, NetMessage msg) {
        NetAction action = msg.getAction();
        if (action.getActionType() != NetAction.ActionType.PONG || action.getPongMessage() == null) {
            ctx.fireChannelRead((Object)msg);
            return;
        }
        try {
            if (PongMessageHandler.getActionId(msg).equals(HEART_BEAT_ACTION_ID)) {
                AtomicInteger heartBeatCounter = (AtomicInteger)ctx.channel().attr(HeartBeatEventHandler.ATTRIBUTE_HEART_BEAT_COUNTER).get();
                if (heartBeatCounter != null) {
                    log.debug("HeartBeat counter: {}", (Object)heartBeatCounter.get());
                }
                ctx.channel().attr(HeartBeatEventHandler.ATTRIBUTE_HEART_BEAT_COUNTER).remove();
                return;
            }
            log.debug("Got a pong message");
            ChannelDecorator decorator = new ChannelDecorator(ctx.channel());
            this.manager.deliverMessage(msg, decorator.getHost());
        }
        catch (Throwable throwable) {
            log.error("Was not possible to deliver pong message", throwable);
        }
        finally {
            ctx.fireChannelReadComplete();
        }
    }

    public PongConsumerManager getManager() {
        return this.manager;
    }

    public void setManager(PongConsumerManager manager) {
        this.manager = manager;
    }

    private static String getActionId(NetMessage netMessage) {
        ActionIdDecorator decorator = new ActionIdDecorator(netMessage);
        return decorator.getActionId();
    }
}

